/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.logging;

import io.apicurio.registry.logging.Logged;
import io.apicurio.registry.logging.LoggerProducer;
import io.apicurio.registry.rest.RegistryApplication;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.slf4j.Logger;

@Interceptor
@Priority(value=2000)
@Logged
public class LoggingInterceptor {
    @Inject
    LoggerProducer loggerProducer;

    @AroundInvoke
    public Object logMethodEntry(InvocationContext context) throws Exception {
        Logger logger = null;
        try {
            Class targetClass = RegistryApplication.class;
            Object target = context.getTarget();
            if (target != null) {
                targetClass = target.getClass();
            }
            logger = this.loggerProducer.getLogger(targetClass);
        }
        catch (Throwable targetClass) {
            // empty catch block
        }
        this.logEnter(context, logger);
        Object rval = context.proceed();
        this.logLeave(context, logger);
        return rval;
    }

    private void logEnter(InvocationContext context, Logger logger) {
        if (context != null && context.getMethod() != null && context.getMethod().getName() != null && context.getParameters() != null && logger != null) {
            logger.trace("ENTERING method [{}] with {} parameters", (Object)context.getMethod().getName(), (Object)context.getParameters().length);
        }
    }

    private void logLeave(InvocationContext context, Logger logger) {
        if (context != null && context.getMethod() != null && context.getMethod().getName() != null && context.getParameters() != null && logger != null) {
            logger.trace("LEAVING method [{}]", (Object)context.getMethod().getName());
        }
    }
}

