/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.logging.audit;

import io.apicurio.registry.logging.audit.AuditHttpRequestContext;
import io.apicurio.registry.logging.audit.AuditHttpRequestInfo;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.control.ActivateRequestContext;
import javax.inject.Inject;
import org.slf4j.Logger;

@ApplicationScoped
public class AuditLogService {
    @Inject
    Logger log;
    @Inject
    AuditHttpRequestContext context;

    @ActivateRequestContext
    public void log(String invoker, String action, String result, Map<String, String> metadata, AuditHttpRequestInfo requestInfo) {
        String forwardedRemoteAddress;
        String remoteAddress;
        if (requestInfo != null) {
            remoteAddress = requestInfo.getSourceIp();
            forwardedRemoteAddress = requestInfo.getForwardedFor();
        } else {
            remoteAddress = this.context.getSourceIp();
            forwardedRemoteAddress = this.context.getForwardedFor();
        }
        StringBuilder m = new StringBuilder();
        m.append(invoker).append(" ").append("action=\"").append(action).append("\" ").append("result=\"").append(result).append("\" ").append("src_ip=\"").append(remoteAddress).append("\" ");
        if (forwardedRemoteAddress != null) {
            m.append("x_forwarded_for=\"").append(forwardedRemoteAddress).append("\" ");
        }
        for (Map.Entry<String, String> e : metadata.entrySet()) {
            m.append(e.getKey()).append("=\"").append(e.getValue()).append("\" ");
        }
        this.log.info(m.toString());
        this.context.setAuditEntryGenerated(true);
    }
}

