/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.logging.audit;

import io.apicurio.registry.logging.audit.AuditLogService;
import io.apicurio.registry.logging.audit.Audited;
import io.quarkus.security.identity.SecurityIdentity;
import java.util.HashMap;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;

@Audited
@Interceptor
@Priority(value=1900)
public class AuditedInterceptor {
    @Inject
    AuditLogService auditLogService;
    @Inject
    SecurityIdentity securityIdentity;

    @AroundInvoke
    public Object auditMethod(InvocationContext context) throws Exception {
        String action;
        String[] annotationParams;
        Audited annotation = context.getMethod().getAnnotation(Audited.class);
        HashMap<String, String> metadata = new HashMap<String, String>();
        if (this.securityIdentity != null && !this.securityIdentity.isAnonymous()) {
            metadata.put("principal_id", this.securityIdentity.getPrincipal().getName());
        }
        if ((annotationParams = annotation.extractParameters()).length > 0) {
            for (int i = 0; i <= annotationParams.length - 2; i += 2) {
                Object parameterValue = context.getParameters()[Integer.parseInt(annotationParams[i])];
                if (parameterValue == null) continue;
                metadata.put(annotationParams[i + 1], parameterValue.toString());
            }
        }
        if ((action = annotation.action()).isEmpty()) {
            action = context.getMethod().getName();
        }
        String result = "success";
        try {
            Object object = context.proceed();
            return object;
        }
        catch (Exception e) {
            result = "failure";
            metadata.put("error_msg", e.getMessage());
            throw e;
        }
        finally {
            this.auditLogService.log("registry.audit", action, result, metadata, null);
        }
    }
}

