/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.logging.audit;

import io.apicurio.registry.logging.audit.AuditHttpRequestContext;
import io.apicurio.registry.logging.audit.AuditLogService;
import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import java.util.Optional;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;

@Provider
@Priority(value=1000)
@ApplicationScoped
public class HttpRequestsAuditFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    @Context
    HttpServletRequest request;
    @Inject
    AuditHttpRequestContext auditContext;
    @Inject
    AuditLogService auditLog;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        this.auditContext.setSourceIp(this.request.getRemoteAddr());
        this.auditContext.setForwardedFor(requestContext.getHeaderString("x-forwarded-for"));
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        if (this.auditContext.isAuditEntryGenerated()) {
            return;
        }
        if (responseContext.getStatus() >= 400) {
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("method", requestContext.getMethod());
            metadata.put("path", requestContext.getUriInfo().getPath());
            metadata.put("response_code", String.valueOf(responseContext.getStatus()));
            metadata.put("user", Optional.ofNullable(requestContext.getSecurityContext()).map(SecurityContext::getUserPrincipal).map(Principal::getName).orElseGet(() -> ""));
            this.auditLog.log("registry.audit", "request", "failure", metadata, null);
        }
    }
}

