/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.logging.sentry;

import io.apicurio.registry.System;
import io.quarkus.runtime.StartupEvent;
import io.sentry.Sentry;
import io.sentry.jul.SentryHandler;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class SentryConfiguration {
    Logger log = LoggerFactory.getLogger(this.getClass());
    @ConfigProperty(name="registry.enable.sentry", defaultValue="false")
    Boolean enableSentry;
    @Inject
    System system;

    void onStart(@Observes StartupEvent ev) throws Exception {
        if (this.enableSentry.booleanValue()) {
            java.lang.System.setProperty("sentry.release", this.system.getVersion());
            Sentry.init();
            LogManager manager = org.jboss.logmanager.LogManager.getLogManager();
            manager.getLogger("").addHandler((Handler)new SentryHandler());
            this.log.info("Sentry initialized");
        }
    }
}

