/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.metrics;

import io.apicurio.registry.metrics.StorageMetricsApply;
import io.apicurio.registry.mt.TenantContext;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.lang.reflect.Method;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.context.ThreadContext;

@Interceptor
@StorageMetricsApply
public class StorageMetricsInterceptor {
    @Inject
    MeterRegistry registry;
    @Inject
    TenantContext tenantContext;
    @Inject
    ThreadContext threadContext;

    @AroundInvoke
    public Object intercept(InvocationContext context) throws Exception {
        Exception exception = null;
        Object result = null;
        Timer.Sample sample = Timer.start((MeterRegistry)this.registry);
        try {
            result = context.proceed();
        }
        catch (Exception ex2) {
            exception = ex2;
        }
        if (exception != null) {
            this.record(sample, context.getMethod(), false);
            throw exception;
        }
        if (result instanceof CompletionStage) {
            CompletionStage r = (CompletionStage)result;
            this.threadContext.withContextCapture(r).whenComplete((ok, ex) -> this.record(sample, context.getMethod(), ex == null));
            return r;
        }
        this.record(sample, context.getMethod(), true);
        return result;
    }

    private void record(Timer.Sample sample, Method method, boolean success) {
        Timer timer = Timer.builder((String)"storage.method.call").description("Timing and results of storage methods calls").tag("tenant_id", this.tenantContext.getTenantIdOrElse("")).tag("method", StorageMetricsInterceptor.getMethodString(method)).tag("success", String.valueOf(success)).register(this.registry);
        sample.stop(timer);
    }

    private static String getMethodString(Method method) {
        StringBuilder res = new StringBuilder();
        res.append(method.getName());
        res.append('(');
        Class<?>[] types = method.getParameterTypes();
        for (int i = 0; i < types.length; ++i) {
            res.append(types[i].getSimpleName());
            if (i == types.length - 1) continue;
            res.append(',');
        }
        res.append(')');
        return res.toString();
    }
}

