/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.metrics.health;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.Optional;

public abstract class AbstractErrorCounterHealthCheck {
    protected long errorCounter = 0L;
    private Instant nextCounterReset;
    private Optional<Duration> statusResetWindowDuration;
    private Optional<Instant> nextStatusReset;
    protected boolean up = true;
    private Duration counterResetWindowDuration;
    private Integer configErrorThreshold;

    protected void init(Integer configErrorThreshold, Integer configCounterResetWindowDurationSec, Integer configStatusResetWindowDurationSec) {
        if (configErrorThreshold == null || configErrorThreshold < 0) {
            throw new IllegalArgumentException("Illegal configuration value of 'registry.metrics.[...].errorThreshold': '" + configErrorThreshold + "'");
        }
        this.configErrorThreshold = configErrorThreshold;
        if (configCounterResetWindowDurationSec == null || configCounterResetWindowDurationSec < 1) {
            throw new IllegalArgumentException("Illegal configuration value of 'registry.metrics.[...].counterResetWindowDurationSec': '" + configCounterResetWindowDurationSec + "'");
        }
        if (configStatusResetWindowDurationSec == null) {
            throw new IllegalArgumentException("Illegal configuration value of 'registry.metrics.[...].statusResetWindowDurationSec': '" + configCounterResetWindowDurationSec + "'");
        }
        this.counterResetWindowDuration = Duration.ofSeconds(configCounterResetWindowDurationSec.intValue());
        this.nextCounterReset = Instant.now().plus(this.counterResetWindowDuration);
        if (configStatusResetWindowDurationSec > 0) {
            this.statusResetWindowDuration = Optional.of(Duration.ofSeconds(configStatusResetWindowDurationSec.intValue()));
        }
    }

    protected synchronized void suspectSuper() {
        this.nextCounterReset = Instant.now().plus(this.counterResetWindowDuration);
        if (++this.errorCounter > (long)this.configErrorThreshold.intValue()) {
            this.up = false;
            this.statusResetWindowDuration.ifPresent(duration -> {
                this.nextStatusReset = Optional.of(Instant.now().plus((TemporalAmount)duration));
            });
        }
    }

    protected synchronized void callSuper() {
        if (!this.up && this.nextStatusReset.isPresent() && Instant.now().isAfter(this.nextStatusReset.get())) {
            this.nextStatusReset = Optional.empty();
            this.up = true;
        }
        if (this.up && this.nextCounterReset != null && Instant.now().isAfter(this.nextCounterReset)) {
            this.nextCounterReset = null;
            this.errorCounter = 0L;
        }
    }
}

