/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.mt;

import io.apicurio.multitenant.api.datamodel.TenantStatusValue;
import io.apicurio.registry.mt.RegistryTenantContext;
import io.apicurio.registry.mt.TenantContext;
import io.apicurio.registry.mt.limits.TenantLimitsConfiguration;
import javax.enterprise.context.ApplicationScoped;
import org.slf4j.MDC;

@ApplicationScoped
public class TenantContextImpl
implements TenantContext {
    private static final String TENANT_ID_KEY = "tenantId";
    private static final RegistryTenantContext EMPTY_CONTEXT = new RegistryTenantContext("_", null, null, TenantStatusValue.READY, null);
    private static final ThreadLocal<RegistryTenantContext> CURRENT = ThreadLocal.withInitial(() -> EMPTY_CONTEXT);

    public static RegistryTenantContext current() {
        return CURRENT.get();
    }

    public static void setCurrentContext(RegistryTenantContext context) {
        CURRENT.set(context);
    }

    public static void clearCurrentContext() {
        TenantContextImpl.setCurrentContext(EMPTY_CONTEXT);
    }

    @Override
    public String tenantId() {
        return CURRENT.get().getTenantId();
    }

    @Override
    public String tenantOwner() {
        return CURRENT.get().getTenantOwner();
    }

    @Override
    public TenantLimitsConfiguration limitsConfig() {
        return CURRENT.get().getLimitsConfiguration();
    }

    @Override
    public void setContext(RegistryTenantContext ctx) {
        TenantContextImpl.setCurrentContext(ctx);
        MDC.put((String)TENANT_ID_KEY, (String)ctx.getTenantId());
    }

    @Override
    public void clearContext() {
        TenantContextImpl.setCurrentContext(EMPTY_CONTEXT);
        MDC.remove((String)TENANT_ID_KEY);
    }

    @Override
    public boolean isLoaded() {
        return !this.tenantId().equals("_");
    }

    @Override
    public TenantStatusValue getTenantStatus() {
        return CURRENT.get().getStatus();
    }
}

