/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.mt;

import io.apicurio.multitenant.api.datamodel.RegistryTenant;
import io.apicurio.multitenant.api.datamodel.TenantStatusValue;
import io.apicurio.registry.auth.AuthConfig;
import io.apicurio.registry.mt.MultitenancyProperties;
import io.apicurio.registry.mt.RegistryTenantContext;
import io.apicurio.registry.mt.TenantMetadataService;
import io.apicurio.registry.mt.TenantNotAuthorizedException;
import io.apicurio.registry.mt.limits.TenantLimitsConfiguration;
import io.apicurio.registry.mt.limits.TenantLimitsConfigurationService;
import io.apicurio.registry.utils.CheckPeriodCache;
import io.quarkus.runtime.StartupEvent;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.jwt.JsonWebToken;
import org.slf4j.Logger;

@ApplicationScoped
public class TenantContextLoader {
    private CheckPeriodCache<String, RegistryTenantContext> contextsCache;
    private RegistryTenantContext defaultTenantContext;
    @Inject
    Logger logger;
    @Inject
    AuthConfig authConfig;
    @Inject
    MultitenancyProperties mtProperties;
    @Inject
    TenantMetadataService tenantMetadataService;
    @Inject
    TenantLimitsConfigurationService limitsConfigurationService;
    @Inject
    Instance<JsonWebToken> jsonWebToken;
    @Inject
    @ConfigProperty(defaultValue="60000", name="registry.tenants.context.cache.check-period")
    Long cacheCheckPeriod;
    @ConfigProperty(name="registry.organization-id.claim-name")
    String organizationIdClaimName;

    public void onStart(@Observes StartupEvent ev) {
        this.contextsCache = new CheckPeriodCache(this.cacheCheckPeriod.longValue());
    }

    public RegistryTenantContext loadRequestContext(String tenantId) {
        return this.loadContext(tenantId, this.mtProperties.isMultitenancyAuthorizationEnabled());
    }

    public RegistryTenantContext loadBatchJobContext(String tenantId) {
        return this.loadContext(tenantId, false);
    }

    private RegistryTenantContext loadContext(String tenantId, boolean checkTenantAuthorization) {
        if (tenantId.equals("_")) {
            return this.defaultTenantContext();
        }
        RegistryTenantContext context = (RegistryTenantContext)this.contextsCache.compute((Object)tenantId, k -> {
            RegistryTenant tenantMetadata = this.tenantMetadataService.getTenant(tenantId);
            TenantLimitsConfiguration limitsConfiguration = this.limitsConfigurationService.fromTenantMetadata(tenantMetadata);
            return new RegistryTenantContext(tenantId, tenantMetadata.getCreatedBy(), limitsConfiguration, tenantMetadata.getStatus(), String.valueOf(tenantMetadata.getOrganizationId()));
        });
        if (checkTenantAuthorization) {
            this.checkTenantAuthorization(context);
        }
        return context;
    }

    public RegistryTenantContext defaultTenantContext() {
        if (this.defaultTenantContext == null) {
            this.defaultTenantContext = new RegistryTenantContext("_", null, this.limitsConfigurationService.defaultConfigurationTenant(), TenantStatusValue.READY, null);
        }
        return this.defaultTenantContext;
    }

    public void invalidateTenantInCache(String tenantId) {
        this.contextsCache.remove((Object)tenantId);
    }

    private void checkTenantAuthorization(RegistryTenantContext tenant) {
        if (this.authConfig.isAuthEnabled()) {
            if (!this.isTokenResolvable()) {
                this.logger.debug("Tenant access attempted without JWT token for tenant {} [allowing because some endpoints allow anonymous access]", (Object)tenant.getTenantId());
                return;
            }
            Optional accessedOrganizationId = ((JsonWebToken)this.jsonWebToken.get()).claim(this.organizationIdClaimName);
            if (accessedOrganizationId.isEmpty() || !this.tenantCanAccessOrganization(tenant, (String)accessedOrganizationId.get())) {
                this.logger.warn("User not authorized to access tenant {}", (Object)tenant.getTenantId());
                throw new TenantNotAuthorizedException("Tenant not authorized");
            }
        }
    }

    private boolean isTokenResolvable() {
        return this.jsonWebToken.isResolvable() && ((JsonWebToken)this.jsonWebToken.get()).getRawToken() != null;
    }

    private boolean tenantCanAccessOrganization(RegistryTenantContext tenant, String accessedOrganizationId) {
        return tenant == null || accessedOrganizationId.equals(tenant.getOrganizationId());
    }

    public void invalidateTenantCache() {
        this.contextsCache.clear();
    }
}

