/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.mt;

import io.apicurio.multitenant.api.datamodel.RegistryTenant;
import io.apicurio.multitenant.api.datamodel.TenantStatusValue;
import io.apicurio.multitenant.api.datamodel.UpdateRegistryTenantRequest;
import io.apicurio.multitenant.client.TenantManagerClient;
import io.apicurio.multitenant.client.exception.RegistryTenantNotFoundException;
import io.apicurio.registry.mt.TenantNotFoundException;
import io.apicurio.registry.utils.OptionalBean;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class TenantMetadataService {
    @Inject
    OptionalBean<TenantManagerClient> tenantManagerClient;

    public RegistryTenant getTenant(String tenantId) throws TenantNotFoundException {
        if (this.tenantManagerClient.isEmpty()) {
            throw new UnsupportedOperationException("Multitenancy is not enabled");
        }
        try {
            return ((TenantManagerClient)this.tenantManagerClient.get()).getTenant(tenantId);
        }
        catch (RegistryTenantNotFoundException e) {
            throw new TenantNotFoundException(e.getMessage());
        }
    }

    public void markTenantAsDeleted(String tenantId) {
        if (this.tenantManagerClient.isEmpty()) {
            throw new UnsupportedOperationException("Multitenancy is not enabled");
        }
        UpdateRegistryTenantRequest ureq = new UpdateRegistryTenantRequest();
        ureq.setStatus(TenantStatusValue.DELETED);
        ((TenantManagerClient)this.tenantManagerClient.get()).updateTenant(tenantId, ureq);
    }
}

