/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.v2;

import io.apicurio.registry.auth.Authorized;
import io.apicurio.registry.auth.AuthorizedLevel;
import io.apicurio.registry.auth.AuthorizedStyle;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.logging.Logged;
import io.apicurio.registry.logging.audit.Audited;
import io.apicurio.registry.metrics.health.liveness.ResponseErrorLivenessCheck;
import io.apicurio.registry.metrics.health.readiness.ResponseTimeoutReadinessCheck;
import io.apicurio.registry.rest.HeadersHack;
import io.apicurio.registry.rest.MissingRequiredParameterException;
import io.apicurio.registry.rest.ParametersConflictException;
import io.apicurio.registry.rest.v2.GroupsResource;
import io.apicurio.registry.rest.v2.V2ApiUtil;
import io.apicurio.registry.rest.v2.beans.ArtifactMetaData;
import io.apicurio.registry.rest.v2.beans.ArtifactSearchResults;
import io.apicurio.registry.rest.v2.beans.EditableMetaData;
import io.apicurio.registry.rest.v2.beans.IfExists;
import io.apicurio.registry.rest.v2.beans.Rule;
import io.apicurio.registry.rest.v2.beans.SortBy;
import io.apicurio.registry.rest.v2.beans.SortOrder;
import io.apicurio.registry.rest.v2.beans.UpdateState;
import io.apicurio.registry.rest.v2.beans.VersionMetaData;
import io.apicurio.registry.rest.v2.beans.VersionSearchResults;
import io.apicurio.registry.rules.RuleApplicationType;
import io.apicurio.registry.rules.RulesService;
import io.apicurio.registry.storage.ArtifactAlreadyExistsException;
import io.apicurio.registry.storage.ArtifactNotFoundException;
import io.apicurio.registry.storage.InvalidArtifactIdException;
import io.apicurio.registry.storage.InvalidGroupIdException;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.VersionNotFoundException;
import io.apicurio.registry.storage.dto.ArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.ArtifactSearchResultsDto;
import io.apicurio.registry.storage.dto.ArtifactVersionMetaDataDto;
import io.apicurio.registry.storage.dto.EditableArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.OrderBy;
import io.apicurio.registry.storage.dto.OrderDirection;
import io.apicurio.registry.storage.dto.RuleConfigurationDto;
import io.apicurio.registry.storage.dto.SearchFilter;
import io.apicurio.registry.storage.dto.SearchFilterType;
import io.apicurio.registry.storage.dto.StoredArtifactDto;
import io.apicurio.registry.storage.dto.VersionSearchResultsDto;
import io.apicurio.registry.types.ArtifactMediaTypes;
import io.apicurio.registry.types.ArtifactState;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.types.Current;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.util.ArtifactIdGenerator;
import io.apicurio.registry.util.ArtifactTypeUtil;
import io.apicurio.registry.util.ContentTypeUtil;
import io.apicurio.registry.utils.ArtifactIdValidator;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.interceptor.Interceptors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jose4j.base64url.Base64;

@ApplicationScoped
@Interceptors(value={ResponseErrorLivenessCheck.class, ResponseTimeoutReadinessCheck.class})
@Logged
public class GroupsResourceImpl
implements GroupsResource {
    private static final String EMPTY_CONTENT_ERROR_MESSAGE = "Empty content is not allowed.";
    @Inject
    @Current
    RegistryStorage storage;
    @Inject
    RulesService rulesService;
    @Inject
    ArtifactIdGenerator idGenerator;
    @Context
    HttpServletRequest request;

    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public Response getLatestArtifact(String groupId, String artifactId) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        ArtifactMetaDataDto metaData = this.storage.getArtifactMetaData(this.gidOrNull(groupId), artifactId);
        if (ArtifactState.DISABLED.equals((Object)metaData.getState())) {
            throw new ArtifactNotFoundException(groupId, artifactId);
        }
        StoredArtifactDto artifact = this.storage.getArtifact(this.gidOrNull(groupId), artifactId);
        MediaType contentType = ArtifactMediaTypes.JSON;
        if (metaData.getType() == ArtifactType.PROTOBUF) {
            contentType = ArtifactMediaTypes.PROTO;
        }
        if (metaData.getType() == ArtifactType.GRAPHQL) {
            contentType = ArtifactMediaTypes.GRAPHQL;
        }
        if (metaData.getType() == ArtifactType.WSDL || metaData.getType() == ArtifactType.XSD || metaData.getType() == ArtifactType.XML) {
            contentType = ArtifactMediaTypes.XML;
        }
        Response.ResponseBuilder builder = Response.ok((Object)artifact.getContent(), (MediaType)contentType);
        this.checkIfDeprecated(metaData::getState, groupId, artifactId, metaData.getVersion(), builder);
        return builder.build();
    }

    @Audited(extractParameters={"0", "artifact_id", "1", "artifact_id", "2", "update_state", "3", "name", "4", "name_encoded", "5", "description", "6", "description_encoded"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public ArtifactMetaData updateArtifact(String groupId, String artifactId, String xRegistryVersion, String xRegistryName, String xRegistryNameEncoded, String xRegistryDescription, String xRegistryDescriptionEncoded, InputStream data) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.maxOneOf("X-Registry-Name", xRegistryName, "X-Registry-Name-Encoded", xRegistryNameEncoded);
        GroupsResourceImpl.maxOneOf("X-Registry-Description", xRegistryDescription, "X-Registry-Description-Encoded", xRegistryDescriptionEncoded);
        String artifactName = GroupsResourceImpl.getOneOf(xRegistryName, GroupsResourceImpl.decode(xRegistryNameEncoded));
        String artifactDescription = GroupsResourceImpl.getOneOf(xRegistryDescription, GroupsResourceImpl.decode(xRegistryDescriptionEncoded));
        ContentHandle content = ContentHandle.create(data);
        if (content.bytes().length == 0) {
            throw new BadRequestException(EMPTY_CONTENT_ERROR_MESSAGE);
        }
        return this.updateArtifactInternal(groupId, artifactId, xRegistryVersion, artifactName, artifactDescription, content, this.getContentType());
    }

    @Audited(extractParameters={"0", "artifact_id", "1", "artifact_id"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void deleteArtifact(String groupId, String artifactId) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        this.storage.deleteArtifact(this.gidOrNull(groupId), artifactId);
    }

    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public ArtifactMetaData getArtifactMetaData(String groupId, String artifactId) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        ArtifactMetaDataDto dto = this.storage.getArtifactMetaData(this.gidOrNull(groupId), artifactId);
        return V2ApiUtil.dtoToMetaData(this.gidOrNull(groupId), artifactId, dto.getType(), dto);
    }

    @Audited(extractParameters={"0", "artifact_id", "1", "artifact_id", "2", "editable_metadata"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void updateArtifactMetaData(String groupId, String artifactId, EditableMetaData data) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        EditableArtifactMetaDataDto dto = new EditableArtifactMetaDataDto();
        dto.setName(data.getName());
        dto.setDescription(data.getDescription());
        dto.setLabels(data.getLabels());
        dto.setProperties(data.getProperties());
        this.storage.updateArtifactMetaData(this.gidOrNull(groupId), artifactId, dto);
    }

    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public VersionMetaData getArtifactVersionMetaDataByContent(String groupId, String artifactId, Boolean canonical, InputStream data) {
        ContentHandle content;
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        if (canonical == null) {
            canonical = Boolean.FALSE;
        }
        if ((content = ContentHandle.create(data)).bytes().length == 0) {
            throw new BadRequestException(EMPTY_CONTENT_ERROR_MESSAGE);
        }
        if (ContentTypeUtil.isApplicationYaml(this.getContentType())) {
            content = ContentTypeUtil.yamlToJson(content);
        }
        ArtifactVersionMetaDataDto dto = this.storage.getArtifactVersionMetaData(this.gidOrNull(groupId), artifactId, canonical, content);
        return V2ApiUtil.dtoToVersionMetaData(this.gidOrNull(groupId), artifactId, dto.getType(), dto);
    }

    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public List<RuleType> listArtifactRules(String groupId, String artifactId) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        return this.storage.getArtifactRules(this.gidOrNull(groupId), artifactId);
    }

    @Audited(extractParameters={"0", "artifact_id", "1", "artifact_id", "2", "rule"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void createArtifactRule(String groupId, String artifactId, Rule data) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        RuleConfigurationDto config = new RuleConfigurationDto();
        config.setConfiguration(data.getConfig());
        this.storage.createArtifactRule(this.gidOrNull(groupId), artifactId, data.getType(), config);
    }

    @Audited(extractParameters={"0", "artifact_id", "1", "artifact_id"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void deleteArtifactRules(String groupId, String artifactId) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        this.storage.deleteArtifactRules(this.gidOrNull(groupId), artifactId);
    }

    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public Rule getArtifactRuleConfig(String groupId, String artifactId, RuleType rule) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("rule", rule);
        RuleConfigurationDto dto = this.storage.getArtifactRule(this.gidOrNull(groupId), artifactId, rule);
        Rule rval = new Rule();
        rval.setConfig(dto.getConfiguration());
        rval.setType(rule);
        return rval;
    }

    @Audited(extractParameters={"0", "artifact_id", "1", "artifact_id", "2", "rule_type", "3", "rule"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public Rule updateArtifactRuleConfig(String groupId, String artifactId, RuleType rule, Rule data) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("rule", rule);
        RuleConfigurationDto dto = new RuleConfigurationDto(data.getConfig());
        this.storage.updateArtifactRule(this.gidOrNull(groupId), artifactId, rule, dto);
        Rule rval = new Rule();
        rval.setType(rule);
        rval.setConfig(data.getConfig());
        return rval;
    }

    @Audited(extractParameters={"0", "artifact_id", "1", "artifact_id", "2", "rule_type"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void deleteArtifactRule(String groupId, String artifactId, RuleType rule) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("rule", rule);
        this.storage.deleteArtifactRule(this.gidOrNull(groupId), artifactId, rule);
    }

    @Audited(extractParameters={"0", "artifact_id", "1", "artifact_id", "2", "update_state"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void updateArtifactState(String groupId, String artifactId, UpdateState data) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("body.state", data.getState());
        this.storage.updateArtifactState(this.gidOrNull(groupId), artifactId, data.getState());
    }

    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void testUpdateArtifact(String groupId, String artifactId, InputStream data) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        ContentHandle content = ContentHandle.create(data);
        if (content.bytes().length == 0) {
            throw new BadRequestException(EMPTY_CONTENT_ERROR_MESSAGE);
        }
        String ct = this.getContentType();
        if (ContentTypeUtil.isApplicationYaml(ct)) {
            content = ContentTypeUtil.yamlToJson(content);
        }
        ArtifactType artifactType = this.lookupArtifactType(groupId, artifactId);
        this.rulesService.applyRules(this.gidOrNull(groupId), artifactId, artifactType, content, RuleApplicationType.UPDATE);
    }

    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public Response getArtifactVersion(String groupId, String artifactId, String version) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("version", version);
        ArtifactVersionMetaDataDto metaData = this.storage.getArtifactVersionMetaData(this.gidOrNull(groupId), artifactId, version);
        if (ArtifactState.DISABLED.equals((Object)metaData.getState())) {
            throw new VersionNotFoundException(groupId, artifactId, version);
        }
        StoredArtifactDto artifact = this.storage.getArtifactVersion(this.gidOrNull(groupId), artifactId, version);
        MediaType contentType = ArtifactMediaTypes.JSON;
        if (metaData.getType() == ArtifactType.PROTOBUF) {
            contentType = ArtifactMediaTypes.PROTO;
        }
        if (metaData.getType() == ArtifactType.GRAPHQL) {
            contentType = ArtifactMediaTypes.GRAPHQL;
        }
        if (metaData.getType() == ArtifactType.WSDL || metaData.getType() == ArtifactType.XSD || metaData.getType() == ArtifactType.XML) {
            contentType = ArtifactMediaTypes.XML;
        }
        Response.ResponseBuilder builder = Response.ok((Object)artifact.getContent(), (MediaType)contentType);
        this.checkIfDeprecated(metaData::getState, groupId, artifactId, version, builder);
        return builder.build();
    }

    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public VersionMetaData getArtifactVersionMetaData(String groupId, String artifactId, String version) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("version", version);
        ArtifactVersionMetaDataDto dto = this.storage.getArtifactVersionMetaData(this.gidOrNull(groupId), artifactId, version);
        return V2ApiUtil.dtoToVersionMetaData(this.gidOrNull(groupId), artifactId, dto.getType(), dto);
    }

    @Audited(extractParameters={"0", "artifact_id", "1", "artifact_id", "2", "update_state", "3", "editable_metadata"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void updateArtifactVersionMetaData(String groupId, String artifactId, String version, EditableMetaData data) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("version", version);
        EditableArtifactMetaDataDto dto = new EditableArtifactMetaDataDto();
        dto.setName(data.getName());
        dto.setDescription(data.getDescription());
        dto.setLabels(data.getLabels());
        dto.setProperties(data.getProperties());
        this.storage.updateArtifactVersionMetaData(this.gidOrNull(groupId), artifactId, version, dto);
    }

    @Audited(extractParameters={"0", "artifact_id", "1", "artifact_id", "2", "update_state"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void deleteArtifactVersionMetaData(String groupId, String artifactId, String version) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("version", version);
        this.storage.deleteArtifactVersionMetaData(this.gidOrNull(groupId), artifactId, version);
    }

    @Audited(extractParameters={"0", "artifact_id", "1", "artifact_id", "2", "update_state", "3", "update_state"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void updateArtifactVersionState(String groupId, String artifactId, String version, UpdateState data) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("version", version);
        this.storage.updateArtifactState(this.gidOrNull(groupId), artifactId, version, data.getState());
    }

    @Authorized(style=AuthorizedStyle.GroupOnly, level=AuthorizedLevel.Read)
    public ArtifactSearchResults listArtifactsInGroup(String groupId, Integer limit, Integer offset, SortOrder order, SortBy orderby) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        if (orderby == null) {
            orderby = SortBy.name;
        }
        if (offset == null) {
            offset = 0;
        }
        if (limit == null) {
            limit = 20;
        }
        OrderBy oBy = OrderBy.valueOf(orderby.name());
        OrderDirection oDir = order == null || order == SortOrder.asc ? OrderDirection.asc : OrderDirection.desc;
        HashSet<SearchFilter> filters = new HashSet<SearchFilter>();
        filters.add(new SearchFilter(SearchFilterType.group, this.gidOrNull(groupId)));
        ArtifactSearchResultsDto resultsDto = this.storage.searchArtifacts(filters, oBy, oDir, offset, limit);
        return V2ApiUtil.dtoToSearchResults(resultsDto);
    }

    @Audited(extractParameters={"0", "artifact_id"})
    @Authorized(style=AuthorizedStyle.GroupOnly, level=AuthorizedLevel.Write)
    public void deleteArtifactsInGroup(String groupId) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        this.storage.deleteArtifacts(this.gidOrNull(groupId));
    }

    @Audited(extractParameters={"0", "artifact_id", "1", "artifact_type", "2", "artifact_id", "3", "update_state", "4", "if_exists", "5", "canonical", "6", "description", "7", "description_encoded", "8", "name", "9", "name_encoded"})
    @Authorized(style=AuthorizedStyle.GroupOnly, level=AuthorizedLevel.Write)
    public ArtifactMetaData createArtifact(String groupId, ArtifactType xRegistryArtifactType, String xRegistryArtifactId, String xRegistryVersion, IfExists ifExists, Boolean canonical, String xRegistryDescription, String xRegistryDescriptionEncoded, String xRegistryName, String xRegistryNameEncoded, InputStream data) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.maxOneOf("X-Registry-Name", xRegistryName, "X-Registry-Name-Encoded", xRegistryNameEncoded);
        GroupsResourceImpl.maxOneOf("X-Registry-Description", xRegistryDescription, "X-Registry-Description-Encoded", xRegistryDescriptionEncoded);
        String artifactName = GroupsResourceImpl.getOneOf(xRegistryName, GroupsResourceImpl.decode(xRegistryNameEncoded));
        String artifactDescription = GroupsResourceImpl.getOneOf(xRegistryDescription, GroupsResourceImpl.decode(xRegistryDescriptionEncoded));
        if (!ArtifactIdValidator.isGroupIdAllowed((String)groupId)) {
            throw new InvalidGroupIdException("Character % and non ASCII characters are not allowed in group IDs.");
        }
        ContentHandle content = ContentHandle.create(data);
        if (content.bytes().length == 0) {
            throw new BadRequestException(EMPTY_CONTENT_ERROR_MESSAGE);
        }
        boolean fcanonical = canonical == null ? Boolean.FALSE : canonical;
        String ct = this.getContentType();
        try {
            String artifactId = xRegistryArtifactId;
            if (artifactId == null || artifactId.trim().isEmpty()) {
                artifactId = this.idGenerator.generate();
            } else if (!ArtifactIdValidator.isArtifactIdAllowed((String)artifactId)) {
                throw new InvalidArtifactIdException("Character % and non ASCII characters are not allowed in artifact IDs.");
            }
            if (ContentTypeUtil.isApplicationYaml(ct)) {
                content = ContentTypeUtil.yamlToJson(content);
            }
            ArtifactType artifactType = ArtifactTypeUtil.determineArtifactType(content, xRegistryArtifactType, ct);
            this.rulesService.applyRules(this.gidOrNull(groupId), artifactId, artifactType, content, RuleApplicationType.CREATE);
            String finalArtifactId = artifactId;
            EditableArtifactMetaDataDto metaData = this.getEditableMetaData(artifactName, artifactDescription);
            ArtifactMetaDataDto amd = this.storage.createArtifactWithMetadata(this.gidOrNull(groupId), artifactId, xRegistryVersion, artifactType, content, metaData);
            return V2ApiUtil.dtoToMetaData(this.gidOrNull(groupId), finalArtifactId, artifactType, amd);
        }
        catch (ArtifactAlreadyExistsException ex) {
            return this.handleIfExists(groupId, xRegistryArtifactId, xRegistryVersion, ifExists, content, ct, fcanonical);
        }
    }

    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public VersionSearchResults listArtifactVersions(String groupId, String artifactId, Integer offset, Integer limit) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        if (offset == null) {
            offset = 0;
        }
        if (limit == null) {
            limit = 20;
        }
        VersionSearchResultsDto resultsDto = this.storage.searchVersions(this.gidOrNull(groupId), artifactId, offset, limit);
        return V2ApiUtil.dtoToSearchResults(resultsDto);
    }

    @Audited(extractParameters={"0", "artifact_id", "1", "artifact_id", "2", "update_state", "3", "name", "4", "description", "5", "description_encoded", "6", "name_encoded"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public VersionMetaData createArtifactVersion(String groupId, String artifactId, String xRegistryVersion, String xRegistryName, String xRegistryDescription, String xRegistryDescriptionEncoded, String xRegistryNameEncoded, InputStream data) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.maxOneOf("X-Registry-Name", xRegistryName, "X-Registry-Name-Encoded", xRegistryNameEncoded);
        GroupsResourceImpl.maxOneOf("X-Registry-Description", xRegistryDescription, "X-Registry-Description-Encoded", xRegistryDescriptionEncoded);
        String artifactName = GroupsResourceImpl.getOneOf(xRegistryName, GroupsResourceImpl.decode(xRegistryNameEncoded));
        String artifactDescription = GroupsResourceImpl.getOneOf(xRegistryDescription, GroupsResourceImpl.decode(xRegistryDescriptionEncoded));
        ContentHandle content = ContentHandle.create(data);
        if (content.bytes().length == 0) {
            throw new BadRequestException(EMPTY_CONTENT_ERROR_MESSAGE);
        }
        String ct = this.getContentType();
        if (ContentTypeUtil.isApplicationYaml(ct)) {
            content = ContentTypeUtil.yamlToJson(content);
        }
        ArtifactType artifactType = this.lookupArtifactType(groupId, artifactId);
        this.rulesService.applyRules(this.gidOrNull(groupId), artifactId, artifactType, content, RuleApplicationType.UPDATE);
        EditableArtifactMetaDataDto metaData = this.getEditableMetaData(artifactName, artifactDescription);
        ArtifactMetaDataDto amd = this.storage.updateArtifactWithMetadata(this.gidOrNull(groupId), artifactId, xRegistryVersion, artifactType, content, metaData);
        return V2ApiUtil.dtoToVersionMetaData(this.gidOrNull(groupId), artifactId, artifactType, amd);
    }

    private void checkIfDeprecated(Supplier<ArtifactState> stateSupplier, String groupId, String artifactId, String version, Response.ResponseBuilder builder) {
        HeadersHack.checkIfDeprecated(stateSupplier, groupId, artifactId, version, builder);
    }

    private ArtifactType lookupArtifactType(String groupId, String artifactId) {
        return this.storage.getArtifactMetaData(this.gidOrNull(groupId), artifactId).getType();
    }

    private String getContentType() {
        return this.request.getContentType();
    }

    private static final void requireParameter(String parameterName, Object parameterValue) {
        if (parameterValue == null) {
            throw new MissingRequiredParameterException(parameterName);
        }
    }

    private static void maxOneOf(String parameterOneName, Object parameterOneValue, String parameterTwoName, Object parameterTwoValue) {
        if (parameterOneValue != null && parameterTwoValue != null) {
            throw new ParametersConflictException(parameterOneName, parameterTwoName);
        }
    }

    private static <T> T getOneOf(T parameterOneValue, T parameterTwoValue) {
        return parameterOneValue != null ? parameterOneValue : parameterTwoValue;
    }

    private static String decode(String encoded) {
        if (encoded == null) {
            return null;
        }
        return new String(Base64.decode((String)encoded));
    }

    private ArtifactMetaData handleIfExists(String groupId, String artifactId, String version, IfExists ifExists, ContentHandle content, String contentType, boolean canonical) {
        ArtifactMetaData artifactMetaData = this.getArtifactMetaData(groupId, artifactId);
        if (ifExists == null) {
            ifExists = IfExists.FAIL;
        }
        switch (ifExists) {
            case UPDATE: {
                return this.updateArtifactInternal(groupId, artifactId, version, content, contentType);
            }
            case RETURN: {
                return artifactMetaData;
            }
            case RETURN_OR_UPDATE: {
                return this.handleIfExistsReturnOrUpdate(groupId, artifactId, version, content, contentType, canonical);
            }
        }
        throw new ArtifactAlreadyExistsException(groupId, artifactId);
    }

    private ArtifactMetaData handleIfExistsReturnOrUpdate(String groupId, String artifactId, String version, ContentHandle content, String contentType, boolean canonical) {
        try {
            ArtifactVersionMetaDataDto mdDto = this.storage.getArtifactVersionMetaData(this.gidOrNull(groupId), artifactId, canonical, content);
            ArtifactMetaData md = V2ApiUtil.dtoToMetaData(this.gidOrNull(groupId), artifactId, null, mdDto);
            return md;
        }
        catch (ArtifactNotFoundException artifactNotFoundException) {
            return this.updateArtifactInternal(groupId, artifactId, version, content, contentType);
        }
    }

    private ArtifactMetaData updateArtifactInternal(String groupId, String artifactId, String version, ContentHandle content, String contentType) {
        return this.updateArtifactInternal(groupId, artifactId, version, null, null, content, contentType);
    }

    private ArtifactMetaData updateArtifactInternal(String groupId, String artifactId, String version, String name, String description, ContentHandle content, String contentType) {
        if (ContentTypeUtil.isApplicationYaml(contentType)) {
            content = ContentTypeUtil.yamlToJson(content);
        }
        ArtifactType artifactType = this.lookupArtifactType(groupId, artifactId);
        this.rulesService.applyRules(this.gidOrNull(groupId), artifactId, artifactType, content, RuleApplicationType.UPDATE);
        EditableArtifactMetaDataDto metaData = this.getEditableMetaData(name, description);
        ArtifactMetaDataDto dto = this.storage.updateArtifactWithMetadata(this.gidOrNull(groupId), artifactId, version, artifactType, content, metaData);
        return V2ApiUtil.dtoToMetaData(this.gidOrNull(groupId), artifactId, artifactType, dto);
    }

    private EditableArtifactMetaDataDto getEditableMetaData(String name, String description) {
        if (name != null || description != null) {
            return new EditableArtifactMetaDataDto(name, description, null, null);
        }
        return null;
    }

    private String gidOrNull(String groupId) {
        if ("default".equalsIgnoreCase(groupId)) {
            return null;
        }
        return groupId;
    }
}

