/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.v2;

import io.apicurio.registry.auth.Authorized;
import io.apicurio.registry.auth.AuthorizedLevel;
import io.apicurio.registry.auth.AuthorizedStyle;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.canon.ContentCanonicalizer;
import io.apicurio.registry.logging.Logged;
import io.apicurio.registry.metrics.health.liveness.ResponseErrorLivenessCheck;
import io.apicurio.registry.metrics.health.readiness.ResponseTimeoutReadinessCheck;
import io.apicurio.registry.rest.v2.SearchResource;
import io.apicurio.registry.rest.v2.V2ApiUtil;
import io.apicurio.registry.rest.v2.beans.ArtifactSearchResults;
import io.apicurio.registry.rest.v2.beans.SortBy;
import io.apicurio.registry.rest.v2.beans.SortOrder;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.dto.ArtifactSearchResultsDto;
import io.apicurio.registry.storage.dto.OrderBy;
import io.apicurio.registry.storage.dto.OrderDirection;
import io.apicurio.registry.storage.dto.SearchFilter;
import io.apicurio.registry.storage.dto.SearchFilterType;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.types.Current;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProvider;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProviderFactory;
import io.apicurio.registry.util.ContentTypeUtil;
import io.apicurio.registry.utils.StringUtil;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.interceptor.Interceptors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Context;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;

@ApplicationScoped
@Interceptors(value={ResponseErrorLivenessCheck.class, ResponseTimeoutReadinessCheck.class})
@Logged
public class SearchResourceImpl
implements SearchResource {
    private static final String EMPTY_CONTENT_ERROR_MESSAGE = "Empty content is not allowed.";
    private static final String CANONICAL_QUERY_PARAM_ERROR_MESSAGE = "When setting 'canonical' to 'true', the 'artifactType' query parameter is also required.";
    @Inject
    Logger log;
    @Inject
    @Current
    RegistryStorage storage;
    @Inject
    ArtifactTypeUtilProviderFactory factory;
    @Context
    HttpServletRequest request;

    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Read)
    public ArtifactSearchResults searchArtifacts(String name, Integer offset, Integer limit, SortOrder order, SortBy orderby, List<String> labels, List<String> properties, String description, String group) {
        if (orderby == null) {
            orderby = SortBy.name;
        }
        if (offset == null) {
            offset = 0;
        }
        if (limit == null) {
            limit = 20;
        }
        OrderBy oBy = OrderBy.valueOf(orderby.name());
        OrderDirection oDir = order == null || order == SortOrder.asc ? OrderDirection.asc : OrderDirection.desc;
        HashSet<SearchFilter> filters = new HashSet<SearchFilter>();
        if (!StringUtil.isEmpty((String)name)) {
            filters.add(new SearchFilter(SearchFilterType.name, name));
        }
        if (!StringUtil.isEmpty((String)description)) {
            filters.add(new SearchFilter(SearchFilterType.description, description));
        }
        if (!StringUtil.isEmpty((String)group)) {
            filters.add(new SearchFilter(SearchFilterType.group, this.gidOrNull(group)));
        }
        if (labels != null && !labels.isEmpty()) {
            labels.forEach(label -> filters.add(new SearchFilter(SearchFilterType.labels, (String)label)));
        }
        if (properties != null && !properties.isEmpty()) {
            properties.forEach(label -> filters.add(new SearchFilter(SearchFilterType.properties, (String)label)));
        }
        ArtifactSearchResultsDto results = this.storage.searchArtifacts(filters, oBy, oDir, offset, limit);
        return V2ApiUtil.dtoToSearchResults(results);
    }

    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Read)
    public ArtifactSearchResults searchArtifactsByContent(Boolean canonical, ArtifactType artifactType, Integer offset, Integer limit, SortOrder order, SortBy orderby, InputStream data) {
        ContentHandle content;
        OrderDirection oDir;
        if (orderby == null) {
            orderby = SortBy.name;
        }
        if (offset == null) {
            offset = 0;
        }
        if (limit == null) {
            limit = 20;
        }
        OrderBy oBy = OrderBy.valueOf(orderby.name());
        OrderDirection orderDirection = oDir = order == null || order == SortOrder.asc ? OrderDirection.asc : OrderDirection.desc;
        if (canonical == null) {
            canonical = Boolean.FALSE;
        }
        if ((content = ContentHandle.create(data)).bytes().length == 0) {
            throw new BadRequestException(EMPTY_CONTENT_ERROR_MESSAGE);
        }
        if (ContentTypeUtil.isApplicationYaml(this.getContentType())) {
            content = ContentTypeUtil.yamlToJson(content);
        }
        HashSet<SearchFilter> filters = new HashSet<SearchFilter>();
        if (canonical.booleanValue() && artifactType != null) {
            String canonicalHash = this.sha256Hash(this.canonicalizeContent(artifactType, content));
            filters.add(new SearchFilter(SearchFilterType.canonicalHash, canonicalHash));
        } else if (!canonical.booleanValue()) {
            String contentHash = this.sha256Hash(content);
            filters.add(new SearchFilter(SearchFilterType.contentHash, contentHash));
        } else {
            throw new BadRequestException(CANONICAL_QUERY_PARAM_ERROR_MESSAGE);
        }
        ArtifactSearchResultsDto results = this.storage.searchArtifacts(filters, oBy, oDir, offset, limit);
        return V2ApiUtil.dtoToSearchResults(results);
    }

    private String getContentType() {
        return this.request.getContentType();
    }

    private String sha256Hash(ContentHandle chandle) {
        return DigestUtils.sha256Hex((byte[])chandle.bytes());
    }

    private String gidOrNull(String groupId) {
        if ("default".equalsIgnoreCase(groupId)) {
            return null;
        }
        return groupId;
    }

    protected ContentHandle canonicalizeContent(ArtifactType artifactType, ContentHandle content) {
        try {
            ArtifactTypeUtilProvider provider = this.factory.getArtifactTypeProvider(artifactType);
            ContentCanonicalizer canonicalizer = provider.getContentCanonicalizer();
            ContentHandle canonicalContent = canonicalizer.canonicalize(content);
            return canonicalContent;
        }
        catch (Exception e) {
            this.log.debug("Failed to canonicalize content of type: {}", (Object)artifactType.name());
            return content;
        }
    }
}

