/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.compatibility;

import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.rules.compatibility.CompatibilityExecutionResult;
import io.apicurio.registry.rules.compatibility.CompatibilityLevel;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public interface CompatibilityChecker {
    default public CompatibilityExecutionResult testCompatibility(CompatibilityLevel compatibilityLevel, List<ContentHandle> existingArtifacts, ContentHandle proposedArtifact) {
        Objects.requireNonNull(compatibilityLevel, "compatibilityLevel MUST NOT be null");
        Objects.requireNonNull(existingArtifacts, "existingArtifacts MUST NOT be null");
        Objects.requireNonNull(proposedArtifact, "proposedArtifact MUST NOT be null");
        if (existingArtifacts.contains(null)) {
            throw new IllegalStateException("existingArtifacts contains null element(s)");
        }
        return this.testCompatibility(compatibilityLevel, existingArtifacts.stream().map(ContentHandle::content).collect(Collectors.toList()), proposedArtifact.content());
    }

    public CompatibilityExecutionResult testCompatibility(CompatibilityLevel var1, List<String> var2, String var3);
}

