/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.compatibility;

import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.logging.Logged;
import io.apicurio.registry.rules.RuleContext;
import io.apicurio.registry.rules.RuleExecutor;
import io.apicurio.registry.rules.RuleViolation;
import io.apicurio.registry.rules.RuleViolationException;
import io.apicurio.registry.rules.compatibility.CompatibilityChecker;
import io.apicurio.registry.rules.compatibility.CompatibilityDifference;
import io.apicurio.registry.rules.compatibility.CompatibilityExecutionResult;
import io.apicurio.registry.rules.compatibility.CompatibilityLevel;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProvider;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProviderFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
@Logged
public class CompatibilityRuleExecutor
implements RuleExecutor {
    @Inject
    ArtifactTypeUtilProviderFactory factory;

    @Override
    public void execute(RuleContext context) throws RuleViolationException {
        List<ContentHandle> existingArtifacts;
        CompatibilityLevel level = CompatibilityLevel.valueOf(context.getConfiguration());
        ArtifactTypeUtilProvider provider = this.factory.getArtifactTypeProvider(context.getArtifactType());
        CompatibilityChecker checker = provider.getCompatibilityChecker();
        CompatibilityExecutionResult compatibilityExecutionResult = checker.testCompatibility(level, existingArtifacts = context.getCurrentContent() != null ? Collections.singletonList(context.getCurrentContent()) : Collections.emptyList(), context.getUpdatedContent());
        if (!compatibilityExecutionResult.isCompatible()) {
            throw new RuleViolationException(String.format("Incompatible artifact: %s [%s], num of incompatible diffs: {%s}", context.getArtifactId(), context.getArtifactType(), compatibilityExecutionResult.getIncompatibleDifferences().size()), RuleType.COMPATIBILITY, context.getConfiguration(), this.transformCompatibilityDiffs(compatibilityExecutionResult.getIncompatibleDifferences()));
        }
    }

    private Set<RuleViolation> transformCompatibilityDiffs(Set<CompatibilityDifference> differences) {
        if (!differences.isEmpty()) {
            HashSet<RuleViolation> res = new HashSet<RuleViolation>();
            for (CompatibilityDifference diff : differences) {
                res.add(diff.asRuleViolation());
            }
            return res;
        }
        return Collections.emptySet();
    }
}

