/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.compatibility;

import com.google.common.collect.ImmutableSet;
import io.apicurio.registry.rules.compatibility.CompatibilityChecker;
import io.apicurio.registry.rules.compatibility.CompatibilityDifference;
import io.apicurio.registry.rules.compatibility.CompatibilityExecutionResult;
import io.apicurio.registry.rules.compatibility.CompatibilityLevel;
import io.apicurio.registry.rules.compatibility.JsonSchemaCompatibilityDifference;
import io.apicurio.registry.rules.compatibility.jsonschema.JsonSchemaDiffLibrary;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.Difference;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public class JsonSchemaCompatibilityChecker
implements CompatibilityChecker {
    @Override
    public CompatibilityExecutionResult testCompatibility(CompatibilityLevel compatibilityLevel, List<String> existingSchemas, String proposedSchema) {
        Objects.requireNonNull(compatibilityLevel, "compatibilityLevel MUST NOT be null");
        Objects.requireNonNull(existingSchemas, "existingSchemas MUST NOT be null");
        Objects.requireNonNull(proposedSchema, "proposedSchema MUST NOT be null");
        if (existingSchemas.isEmpty()) {
            return CompatibilityExecutionResult.compatible();
        }
        ImmutableSet incompatibleDiffs = new HashSet();
        String lastExistingSchema = existingSchemas.get(existingSchemas.size() - 1);
        switch (compatibilityLevel) {
            case BACKWARD: {
                incompatibleDiffs = JsonSchemaDiffLibrary.getIncompatibleDifferences((String)lastExistingSchema, (String)proposedSchema);
                break;
            }
            case BACKWARD_TRANSITIVE: {
                incompatibleDiffs = this.transitively(existingSchemas, proposedSchema, JsonSchemaDiffLibrary::getIncompatibleDifferences);
                break;
            }
            case FORWARD: {
                incompatibleDiffs = JsonSchemaDiffLibrary.getIncompatibleDifferences((String)proposedSchema, (String)lastExistingSchema);
                break;
            }
            case FORWARD_TRANSITIVE: {
                incompatibleDiffs = this.transitively(existingSchemas, proposedSchema, (existing, proposed) -> JsonSchemaDiffLibrary.getIncompatibleDifferences((String)proposed, (String)existing));
                break;
            }
            case FULL: {
                incompatibleDiffs = ImmutableSet.builder().addAll((Iterable)JsonSchemaDiffLibrary.getIncompatibleDifferences((String)lastExistingSchema, (String)proposedSchema)).addAll((Iterable)JsonSchemaDiffLibrary.getIncompatibleDifferences((String)proposedSchema, (String)lastExistingSchema)).build();
                break;
            }
            case FULL_TRANSITIVE: {
                incompatibleDiffs = ImmutableSet.builder().addAll(this.transitively(existingSchemas, proposedSchema, JsonSchemaDiffLibrary::getIncompatibleDifferences)).addAll(this.transitively(existingSchemas, proposedSchema, (existing, proposed) -> JsonSchemaDiffLibrary.getIncompatibleDifferences((String)proposed, (String)existing))).build();
                break;
            }
        }
        Set<CompatibilityDifference> diffs = incompatibleDiffs.stream().map(JsonSchemaCompatibilityDifference::new).collect(Collectors.toSet());
        return CompatibilityExecutionResult.incompatible(diffs);
    }

    private Set<Difference> transitively(List<String> existingSchemas, String proposedSchema, BiFunction<String, String, Set<Difference>> checkExistingProposed) {
        HashSet<Difference> result = new HashSet<Difference>();
        for (int i = existingSchemas.size() - 1; i >= 0; --i) {
            Set<Difference> current = checkExistingProposed.apply(existingSchemas.get(i), proposedSchema);
            result.addAll(current);
        }
        return result;
    }
}

