/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.validity;

import graphql.schema.idl.SchemaParser;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.rules.RuleViolationException;
import io.apicurio.registry.rules.validity.ContentValidator;
import io.apicurio.registry.rules.validity.ValidityLevel;
import io.apicurio.registry.types.RuleType;
import javax.enterprise.context.ApplicationScoped;

@ApplicationScoped
public class GraphQLContentValidator
implements ContentValidator {
    @Override
    public void validate(ValidityLevel level, ContentHandle content) throws RuleViolationException {
        if (level == ValidityLevel.SYNTAX_ONLY || level == ValidityLevel.FULL) {
            try {
                new SchemaParser().parse(content.content());
            }
            catch (Exception e) {
                throw new RuleViolationException("Syntax violation for GraphQL artifact.", RuleType.VALIDITY, level.name(), e);
            }
        }
    }
}

