/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.validity;

import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.rules.RuleViolationException;
import io.apicurio.registry.rules.validity.ValidityLevel;
import io.apicurio.registry.rules.validity.XmlContentValidator;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.util.SchemaFactoryAccessor;
import java.io.InputStream;
import javax.enterprise.context.ApplicationScoped;
import javax.xml.transform.stream.StreamSource;

@ApplicationScoped
public class XsdContentValidator
extends XmlContentValidator {
    @Override
    public void validate(ValidityLevel level, ContentHandle artifactContent) throws RuleViolationException {
        super.validate(level, artifactContent);
        if (level == ValidityLevel.FULL) {
            try (InputStream semanticStream = artifactContent.stream();){
                StreamSource source = new StreamSource(semanticStream);
                SchemaFactoryAccessor.getSchemaFactory().newSchema(source);
            }
            catch (Exception e) {
                throw new RuleViolationException("Syntax violation for XSD Schema artifact.", RuleType.VALIDITY, level.name(), e);
            }
        }
    }
}

