/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.services;

import io.apicurio.registry.mt.MultitenancyProperties;
import io.quarkus.runtime.StartupEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;

@ApplicationScoped
public class DisabledApisMatcherService {
    @Inject
    Logger log;
    private static final String UI_PATTERN = "/ui/.*";
    private static final String APIS_PATTERN = "/apis/.*";
    private static final String API_PATTERN = "/api/.*";
    private List<Pattern> disabledPatternsList;
    private List<Pattern> apisPatterns;
    @Inject
    MultitenancyProperties mtProperties;
    @Inject
    @ConfigProperty(name="registry.disable.apis")
    Optional<List<String>> disableRegexps;

    public void init(@Observes StartupEvent ev) {
        this.disabledPatternsList = new ArrayList<Pattern>();
        ArrayList<String> regexps = new ArrayList<String>();
        if (this.mtProperties.isMultitenancyEnabled()) {
            this.log.debug("Adding UI to disabled APIs, direct access to UI is disabled in multitenancy deployments");
            regexps.add(UI_PATTERN);
        }
        if (this.disableRegexps.isPresent()) {
            regexps.addAll((Collection)this.disableRegexps.get());
        }
        for (String regexp : regexps) {
            try {
                Pattern p = Pattern.compile(regexp);
                this.disabledPatternsList.add(p);
            }
            catch (PatternSyntaxException e) {
                this.log.error("An error occurred parsing a regexp for disabling APIs: " + regexp, (Throwable)e);
            }
        }
        this.apisPatterns = Stream.of(APIS_PATTERN, API_PATTERN).map(r -> Pattern.compile(r)).collect(Collectors.toList());
    }

    public boolean isDisabled(String requestPath) {
        for (Pattern pattern : this.disabledPatternsList) {
            if (!pattern.matcher(requestPath).matches()) continue;
            this.log.warn("Request {} is rejected because it's disabled by pattern {}", (Object)requestPath, (Object)pattern.pattern());
            return true;
        }
        return false;
    }

    public boolean isApiRequest(String requestPath) {
        for (Pattern pattern : this.apisPatterns) {
            if (!pattern.matcher(requestPath).matches()) continue;
            return true;
        }
        return false;
    }
}

