/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.services.auth;

import io.apicurio.registry.logging.audit.AuditHttpRequestInfo;
import io.apicurio.registry.logging.audit.AuditLogService;
import io.apicurio.registry.services.auth.CredentialsHelper;
import io.apicurio.registry.services.auth.CustomAuthenticationMechanism;
import io.apicurio.rest.client.auth.OidcAuth;
import io.apicurio.rest.client.auth.exception.NotAuthorizedException;
import io.quarkus.oidc.AccessTokenCredential;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.credential.TokenCredential;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.identity.request.TokenAuthenticationRequest;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpCredentialTransport;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;

@Alternative
@Priority(value=1)
@ApplicationScoped
public class BasicAuthClientCredentialsMechanism
implements HttpAuthenticationMechanism {
    @Inject
    CustomAuthenticationMechanism customAuthenticationMechanism;
    @ConfigProperty(name="registry.auth.enabled")
    boolean authEnabled;
    @ConfigProperty(name="registry.auth.basic-auth-client-credentials.enabled")
    boolean fakeBasicAuthEnabled;
    @ConfigProperty(name="registry.auth.token.endpoint")
    String authServerUrl;
    @Inject
    AuditLogService auditLog;
    @Inject
    Logger log;

    public Uni<SecurityIdentity> authenticate(RoutingContext context, IdentityProviderManager identityProviderManager) {
        if (this.authEnabled) {
            this.setAuditLogger(context);
            if (this.fakeBasicAuthEnabled) {
                Pair<String, String> clientCredentials = CredentialsHelper.extractCredentialsFromContext(context);
                if (null != clientCredentials) {
                    try {
                        return this.authenticateWithClientCredentials(clientCredentials, context, identityProviderManager);
                    }
                    catch (NotAuthorizedException ex) {
                        throw new AuthenticationFailedException();
                    }
                }
                return this.customAuthenticationMechanism.authenticate(context, identityProviderManager);
            }
            return this.customAuthenticationMechanism.authenticate(context, identityProviderManager);
        }
        return Uni.createFrom().nullItem();
    }

    private void setAuditLogger(RoutingContext context) {
        BiConsumer failureHandler = (BiConsumer)context.get("io.quarkus.vertx.http.auth-failure-handler");
        BiConsumer<RoutingContext, Throwable> auditWrapper = (ctx, ex) -> {
            failureHandler.accept(ctx, ex);
            if (ctx.response().getStatusCode() >= 400) {
                HashMap<String, String> metadata = new HashMap<String, String>();
                metadata.put("method", ctx.request().method().name());
                metadata.put("path", ctx.request().path());
                metadata.put("response_code", String.valueOf(ctx.response().getStatusCode()));
                if (ex != null) {
                    metadata.put("error_msg", ex.getMessage());
                }
                this.auditLog.log("registry.audit", "authenticate", "failure", metadata, new AuditHttpRequestInfo((RoutingContext)ctx){
                    final /* synthetic */ RoutingContext val$ctx;
                    {
                        this.val$ctx = routingContext;
                    }

                    @Override
                    public String getSourceIp() {
                        return this.val$ctx.request().remoteAddress().toString();
                    }

                    @Override
                    public String getForwardedFor() {
                        return this.val$ctx.request().getHeader("x-forwarded-for");
                    }
                });
            }
        };
        context.put("io.quarkus.vertx.http.auth-failure-handler", auditWrapper);
    }

    public Uni<ChallengeData> getChallenge(RoutingContext context) {
        return this.customAuthenticationMechanism.getChallenge(context);
    }

    public Set<Class<? extends AuthenticationRequest>> getCredentialTypes() {
        return Collections.singleton(TokenAuthenticationRequest.class);
    }

    public HttpCredentialTransport getCredentialTransport() {
        return new HttpCredentialTransport(HttpCredentialTransport.Type.AUTHORIZATION, "bearer");
    }

    private Uni<SecurityIdentity> authenticateWithClientCredentials(Pair<String, String> clientCredentials, RoutingContext context, IdentityProviderManager identityProviderManager) {
        String jwtToken = new OidcAuth(this.authServerUrl, (String)clientCredentials.getLeft(), (String)clientCredentials.getRight(), Optional.empty()).authenticate();
        return identityProviderManager.authenticate((AuthenticationRequest)new TokenAuthenticationRequest((TokenCredential)new AccessTokenCredential(jwtToken, context)));
    }
}

