/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.services.auth;

import io.apicurio.registry.services.auth.CredentialsHelper;
import io.apicurio.rest.client.auth.OidcAuth;
import io.quarkus.oidc.AccessTokenCredential;
import io.quarkus.oidc.runtime.BearerAuthenticationMechanism;
import io.quarkus.oidc.runtime.OidcAuthenticationMechanism;
import io.quarkus.security.credential.TokenCredential;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.identity.request.TokenAuthenticationRequest;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpCredentialTransport;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class CustomAuthenticationMechanism
implements HttpAuthenticationMechanism {
    @Inject
    OidcAuthenticationMechanism oidcAuthenticationMechanism;
    @ConfigProperty(name="registry.auth.token.endpoint")
    String authServerUrl;
    @ConfigProperty(name="registry.auth.client-secret")
    Optional<String> clientSecret;
    @ConfigProperty(name="quarkus.oidc.client-id")
    String clientId;
    @ConfigProperty(name="registry.auth.enabled")
    boolean authEnabled;
    private final BearerAuthenticationMechanism bearerAuth = new BearerAuthenticationMechanism();

    public Uni<SecurityIdentity> authenticate(RoutingContext context, IdentityProviderManager identityProviderManager) {
        if (this.authEnabled) {
            if (this.clientSecret.isEmpty()) {
                return this.oidcAuthenticationMechanism.authenticate(context, identityProviderManager);
            }
            Pair<String, String> credentialsFromContext = CredentialsHelper.extractCredentialsFromContext(context);
            if (credentialsFromContext != null) {
                String jwtToken = new OidcAuth(this.authServerUrl, this.clientId, this.clientSecret.get(), Optional.empty()).obtainAccessTokenWithBasicCredentials((String)credentialsFromContext.getLeft(), (String)credentialsFromContext.getRight());
                if (jwtToken != null) {
                    return identityProviderManager.authenticate((AuthenticationRequest)new TokenAuthenticationRequest((TokenCredential)new AccessTokenCredential(jwtToken, context)));
                }
            } else {
                return this.oidcAuthenticationMechanism.authenticate(context, identityProviderManager);
            }
        }
        return Uni.createFrom().nullItem();
    }

    public Uni<ChallengeData> getChallenge(RoutingContext context) {
        return this.bearerAuth.getChallenge(context);
    }

    public Set<Class<? extends AuthenticationRequest>> getCredentialTypes() {
        return Collections.singleton(TokenAuthenticationRequest.class);
    }

    public HttpCredentialTransport getCredentialTransport() {
        return new HttpCredentialTransport(HttpCredentialTransport.Type.AUTHORIZATION, "bearer");
    }
}

