/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.services.http;

import io.apicurio.multitenant.client.exception.TenantManagerClientException;
import io.apicurio.registry.ccompat.rest.error.ConflictException;
import io.apicurio.registry.ccompat.rest.error.UnprocessableEntityException;
import io.apicurio.registry.metrics.health.liveness.LivenessUtil;
import io.apicurio.registry.metrics.health.liveness.ResponseErrorLivenessCheck;
import io.apicurio.registry.mt.TenantNotAuthorizedException;
import io.apicurio.registry.mt.TenantNotFoundException;
import io.apicurio.registry.mt.limits.LimitExceededException;
import io.apicurio.registry.rest.MissingRequiredParameterException;
import io.apicurio.registry.rest.ParametersConflictException;
import io.apicurio.registry.rest.v2.beans.Error;
import io.apicurio.registry.rest.v2.beans.RuleViolationCause;
import io.apicurio.registry.rest.v2.beans.RuleViolationError;
import io.apicurio.registry.rules.DefaultRuleDeletionException;
import io.apicurio.registry.rules.RuleViolation;
import io.apicurio.registry.rules.RuleViolationException;
import io.apicurio.registry.services.http.ErrorHttpResponse;
import io.apicurio.registry.storage.AlreadyExistsException;
import io.apicurio.registry.storage.ArtifactAlreadyExistsException;
import io.apicurio.registry.storage.ArtifactNotFoundException;
import io.apicurio.registry.storage.ContentNotFoundException;
import io.apicurio.registry.storage.DownloadNotFoundException;
import io.apicurio.registry.storage.GroupNotFoundException;
import io.apicurio.registry.storage.InvalidArtifactIdException;
import io.apicurio.registry.storage.InvalidArtifactStateException;
import io.apicurio.registry.storage.InvalidArtifactTypeException;
import io.apicurio.registry.storage.InvalidGroupIdException;
import io.apicurio.registry.storage.LogConfigurationNotFoundException;
import io.apicurio.registry.storage.NotFoundException;
import io.apicurio.registry.storage.RoleMappingAlreadyExistsException;
import io.apicurio.registry.storage.RoleMappingNotFoundException;
import io.apicurio.registry.storage.RuleAlreadyExistsException;
import io.apicurio.registry.storage.RuleNotFoundException;
import io.apicurio.registry.storage.VersionNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;

@ApplicationScoped
public class RegistryExceptionMapperService {
    private static final int HTTP_UNPROCESSABLE_ENTITY = 422;
    private static final Map<Class<? extends Exception>, Integer> CODE_MAP;
    @Inject
    Logger log;
    @Inject
    ResponseErrorLivenessCheck liveness;
    @Inject
    LivenessUtil livenessUtil;

    public static Set<Class<? extends Exception>> getIgnored() {
        return CODE_MAP.keySet();
    }

    public ErrorHttpResponse mapException(Throwable t) {
        int code;
        Response response = null;
        if (t instanceof WebApplicationException) {
            WebApplicationException wae = (WebApplicationException)t;
            response = wae.getResponse();
            code = response.getStatus();
        } else {
            code = CODE_MAP.getOrDefault(t.getClass(), 500);
        }
        if (code == 500) {
            if (!this.livenessUtil.isIgnoreError(t)) {
                this.liveness.suspectWithException(t);
                this.log.error(t.getMessage(), t);
            } else if (this.log.isDebugEnabled()) {
                this.log.error(t.getMessage(), t);
            }
        }
        Error error = this.toError(t, code);
        return new ErrorHttpResponse(code, error, response);
    }

    private Error toError(Throwable t, int code) {
        Error error;
        if (t instanceof RuleViolationException) {
            RuleViolationException rve = (RuleViolationException)t;
            error = new RuleViolationError();
            ((RuleViolationError)error).setCauses(this.toRestCauses(rve.getCauses()));
        } else {
            error = new Error();
        }
        error.setErrorCode(Integer.valueOf(code));
        error.setMessage(t.getLocalizedMessage());
        error.setDetail(this.getStackTrace(t));
        error.setName(t.getClass().getSimpleName());
        return error;
    }

    private List<RuleViolationCause> toRestCauses(Set<RuleViolation> violations) {
        if (violations == null) {
            return null;
        }
        return violations.stream().map(violation -> {
            RuleViolationCause cause = new RuleViolationCause();
            cause.setContext(violation.getContext());
            cause.setDescription(violation.getDescription());
            return cause;
        }).collect(Collectors.toList());
    }

    private String getStackTrace(Throwable t) {
        String string;
        StringWriter writer = new StringWriter();
        try {
            t.printStackTrace(new PrintWriter(writer));
            string = writer.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return null;
            }
        }
        writer.close();
        return string;
    }

    static {
        HashMap<Class, Integer> map = new HashMap<Class, Integer>();
        map.put(AlreadyExistsException.class, 409);
        map.put(ArtifactAlreadyExistsException.class, 409);
        map.put(ArtifactNotFoundException.class, 404);
        map.put(ContentNotFoundException.class, 404);
        map.put(BadRequestException.class, 400);
        map.put(InvalidArtifactStateException.class, 400);
        map.put(NotFoundException.class, 404);
        map.put(RuleAlreadyExistsException.class, 409);
        map.put(RuleNotFoundException.class, 404);
        map.put(RuleViolationException.class, 409);
        map.put(DefaultRuleDeletionException.class, 409);
        map.put(VersionNotFoundException.class, 404);
        map.put(ConflictException.class, 409);
        map.put(UnprocessableEntityException.class, 422);
        map.put(InvalidArtifactTypeException.class, 400);
        map.put(InvalidArtifactIdException.class, 400);
        map.put(TenantNotFoundException.class, 404);
        map.put(InvalidGroupIdException.class, 400);
        map.put(MissingRequiredParameterException.class, 400);
        map.put(LogConfigurationNotFoundException.class, 404);
        map.put(GroupNotFoundException.class, 404);
        map.put(LimitExceededException.class, 409);
        map.put(TenantNotAuthorizedException.class, 403);
        map.put(RoleMappingAlreadyExistsException.class, 409);
        map.put(RoleMappingNotFoundException.class, 404);
        map.put(TenantManagerClientException.class, 500);
        map.put(ParametersConflictException.class, 409);
        map.put(DownloadNotFoundException.class, 404);
        CODE_MAP = Collections.unmodifiableMap(map);
    }
}

