/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.sql;

import io.agroal.api.AgroalDataSource;
import io.apicurio.registry.storage.RegistryStorageException;
import io.apicurio.registry.storage.impl.sql.jdb.HandleCallback;
import io.apicurio.registry.storage.impl.sql.jdb.HandleImpl;
import io.apicurio.registry.types.RegistryException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class HandleFactory {
    @Inject
    AgroalDataSource dataSource;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <R, X extends Exception> R withHandle(HandleCallback<R, X> callback) throws X {
        try (Connection connection = this.dataSource.getConnection();){
            HandleImpl handleImpl = new HandleImpl(connection);
            R r = callback.withHandle(handleImpl);
            return r;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public <R, X extends Exception> R withHandleNoException(HandleCallback<R, X> callback) throws RegistryStorageException {
        try {
            return this.withHandle(callback);
        }
        catch (RegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RegistryStorageException(e);
        }
    }
}

