/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.sql;

import io.apicurio.registry.storage.impl.sql.CommonSqlStatements;

public class PostgreSQLSqlStatements
extends CommonSqlStatements {
    @Override
    public String dbType() {
        return "postgresql";
    }

    @Override
    public boolean isPrimaryKeyViolation(Exception error) {
        return error.getMessage().contains("violates unique constraint");
    }

    @Override
    public boolean isForeignKeyViolation(Exception error) {
        return error.getMessage().contains("violates foreign key constraint");
    }

    @Override
    public String isDatabaseInitialized() {
        return "SELECT count(*) AS count FROM information_schema.tables WHERE table_name = 'artifacts'";
    }

    @Override
    public String upsertContent() {
        return "INSERT INTO content (tenantId, contentId, canonicalHash, contentHash, content) VALUES (?, ?, ?, ?, ?) ON CONFLICT (tenantId, contentHash) DO NOTHING";
    }

    @Override
    public String upsertLogConfiguration() {
        return "INSERT INTO logconfiguration (logger, loglevel) VALUES (?, ?) ON CONFLICT (logger) DO UPDATE SET loglevel = ?";
    }

    @Override
    public String getNextSequenceValue() {
        return "INSERT INTO sequences (tenantId, name, value) VALUES (?, ?, 1) ON CONFLICT (tenantId, name) DO UPDATE SET value = sequences.value + 1 RETURNING value";
    }

    @Override
    public String resetSequenceValue() {
        return "INSERT INTO sequences (tenantId, name, value) VALUES (?, ?, ?) ON CONFLICT (tenantId, name) DO UPDATE SET value = ?";
    }
}

