/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.metrics;

import io.apicurio.registry.mt.TenantContext;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.types.Current;
import io.apicurio.registry.utils.CheckPeriodCache;
import io.quarkus.runtime.StartupEvent;
import java.util.concurrent.atomic.AtomicLong;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;

@ApplicationScoped
public class StorageMetricsStore {
    @Inject
    Logger log;
    @Inject
    @ConfigProperty(defaultValue="30000", name="registry.storage.metrics.cache.check-period")
    Long limitsCheckPeriod;
    @Inject
    TenantContext tenantContext;
    @Inject
    @Current
    RegistryStorage storage;
    private CheckPeriodCache<String, AtomicLong> totalSchemasCounters;
    private CheckPeriodCache<String, AtomicLong> artifactsCounters;
    private CheckPeriodCache<ArtifactVersionKey, AtomicLong> artifactVersionsCounters;

    public void onStart(@Observes StartupEvent ev) {
        this.totalSchemasCounters = new CheckPeriodCache(this.limitsCheckPeriod.longValue());
        this.artifactsCounters = new CheckPeriodCache(this.limitsCheckPeriod.longValue());
        this.artifactVersionsCounters = new CheckPeriodCache(this.limitsCheckPeriod.longValue());
    }

    public long getOrInitializeTotalSchemasCounter() {
        return ((AtomicLong)this.totalSchemasCounters.compute((Object)this.tenantContext.tenantId(), k -> {
            this.log.info("Initializing total schemas counter, tid {}", (Object)this.tenantContext.tenantId());
            long count = this.storage.countTotalArtifactVersions();
            return new AtomicLong(count);
        })).get();
    }

    public long getOrInitializeArtifactsCounter() {
        return ((AtomicLong)this.artifactsCounters.compute((Object)this.tenantContext.tenantId(), k -> {
            long count = this.storage.countArtifacts();
            return new AtomicLong(count);
        })).get();
    }

    public long getOrInitializeArtifactVersionsCounter(String groupId, String artifactId) {
        ArtifactVersionKey avk = new ArtifactVersionKey();
        avk.tenantId = this.tenantContext.tenantId();
        avk.groupId = groupId;
        avk.artifactId = artifactId;
        return ((AtomicLong)this.artifactVersionsCounters.compute((Object)avk, k -> {
            long count = this.storage.countArtifactVersions(groupId, artifactId);
            return new AtomicLong(count);
        })).get();
    }

    public void incrementTotalSchemasCounter() {
        this.log.info("Incrementing total schemas counter, tid {}", (Object)this.tenantContext.tenantId());
        AtomicLong counter = (AtomicLong)this.totalSchemasCounters.get((Object)this.tenantContext.tenantId());
        if (counter == null) {
            return;
        }
        counter.incrementAndGet();
    }

    public void incrementArtifactsCounter() {
        AtomicLong counter = (AtomicLong)this.artifactsCounters.get((Object)this.tenantContext.tenantId());
        if (counter == null) {
            return;
        }
        counter.incrementAndGet();
    }

    public void incrementArtifactVersionsCounter(String groupId, String artifactId) {
        ArtifactVersionKey avk = new ArtifactVersionKey();
        avk.tenantId = this.tenantContext.tenantId();
        avk.groupId = groupId;
        avk.artifactId = artifactId;
        AtomicLong counter = (AtomicLong)this.artifactVersionsCounters.get((Object)avk);
        if (counter == null) {
            return;
        }
        counter.incrementAndGet();
    }

    public void resetTotalSchemasCounter() {
        this.totalSchemasCounters.remove((Object)this.tenantContext.tenantId());
    }

    public void resetArtifactsCounter() {
        this.artifactsCounters.remove((Object)this.tenantContext.tenantId());
    }

    public void resetArtifactVersionsCounter(String groupId, String artifactId) {
        ArtifactVersionKey avk = new ArtifactVersionKey();
        avk.tenantId = this.tenantContext.tenantId();
        avk.groupId = groupId;
        avk.artifactId = artifactId;
        this.artifactVersionsCounters.remove((Object)avk);
    }

    private static class ArtifactVersionKey {
        String tenantId;
        String groupId;
        String artifactId;

        private ArtifactVersionKey() {
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ArtifactVersionKey)) {
                return false;
            }
            ArtifactVersionKey other = (ArtifactVersionKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$tenantId = this.tenantId;
            String other$tenantId = other.tenantId;
            if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
                return false;
            }
            String this$groupId = this.groupId;
            String other$groupId = other.groupId;
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$artifactId = this.artifactId;
            String other$artifactId = other.artifactId;
            return !(this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ArtifactVersionKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $tenantId = this.tenantId;
            result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
            String $groupId = this.groupId;
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $artifactId = this.artifactId;
            result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
            return result;
        }
    }
}

