/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ui.config;

import io.apicurio.registry.utils.RegistryProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;

@ApplicationScoped
public class UiConfigProperties {
    @Inject
    Logger log;
    @Inject
    @ConfigProperty(name="registry.ui.features.readOnly", defaultValue="false")
    boolean featureReadOnly;
    @Inject
    @ConfigProperty(name="registry.ui.config.uiContextPath", defaultValue="/ui/")
    String uiContextPath;
    @Inject
    @ConfigProperty(name="registry.ui.config.apiUrl")
    String apiUrl;
    @Inject
    @ConfigProperty(name="quarkus.oidc.tenant-enabled", defaultValue="false")
    boolean tenantEnabled;
    private final Map<String, Object> keycloakConfig = new HashMap<String, Object>();

    public UiConfigProperties(@RegistryProperties(value={"registry.ui.config.auth.keycloak"}) Properties kcProperties) {
        kcProperties.stringPropertyNames().forEach(key -> this.keycloakConfig.put((String)key, kcProperties.get(key)));
    }

    @PostConstruct
    void onConstruct() {
        this.log.debug("============> kcProperties  " + this.keycloakConfig);
        this.log.debug("============> tenantEnabled  " + this.tenantEnabled);
        this.log.debug("============> featureReadOnly  " + this.featureReadOnly);
        this.log.debug("============> uiContextPath  " + this.uiContextPath);
        this.log.debug("============> apiUrl  " + this.apiUrl);
    }

    public Map<String, Object> getKeycloakProperties() {
        return this.keycloakConfig;
    }

    public boolean isFeatureReadOnly() {
        return this.featureReadOnly;
    }

    public String getUiContextPath() {
        return this.uiContextPath;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public boolean isKeycloakAuthEnabled() {
        return this.tenantEnabled;
    }
}

