/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ui.servlets;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class RedirectFilter
implements Filter {
    @ConfigProperty(name="registry.enable-redirects")
    Boolean redirectsEnabled;
    @ConfigProperty(name="registry.redirects")
    Map<String, String> redirectsConfig;
    Map<String, String> redirects = new HashMap<String, String>();

    @PostConstruct
    void init() {
        if (this.redirectsEnabled != null && this.redirectsEnabled.booleanValue()) {
            this.redirectsConfig.values().forEach(value -> {
                String[] split = value.split(",");
                if (split != null && split.length == 2) {
                    String key = split[0];
                    String val = split[1];
                    this.redirects.put(key, val);
                }
            });
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (this.redirectsEnabled != null && this.redirectsEnabled.booleanValue()) {
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)res;
            String servletPath = request.getServletPath();
            if (servletPath == null || "".equals(servletPath) || "/".equals(servletPath)) {
                servletPath = "/";
            }
            if (this.redirects.containsKey(servletPath)) {
                response.sendRedirect(this.redirects.get(servletPath));
                return;
            }
        }
        chain.doFilter(req, res);
    }

    public void destroy() {
    }
}

