/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.storage.InvalidArtifactTypeException;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.util.DocumentBuilderAccessor;
import io.apicurio.registry.utils.protobuf.schema.ProtobufFile;
import java.io.InputStream;
import javax.ws.rs.BadRequestException;
import org.apache.avro.Schema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class ArtifactTypeUtil {
    private static final ObjectMapper mapper = new ObjectMapper();

    private ArtifactTypeUtil() {
    }

    public static ArtifactType determineArtifactType(ContentHandle content, ArtifactType xArtifactType, String contentType) {
        ArtifactType artifactType = xArtifactType;
        if (artifactType == null && (artifactType = ArtifactTypeUtil.getArtifactTypeFromContentType(contentType)) == null) {
            artifactType = ArtifactTypeUtil.discoverType(content, contentType);
        }
        return artifactType;
    }

    private static ArtifactType getArtifactTypeFromContentType(String contentType) {
        String[] split;
        if (contentType != null && contentType.contains("application/json") && contentType.indexOf(59) != -1 && (split = contentType.split(";")).length > 1) {
            for (String s : split) {
                if (!s.contains("artifactType=")) continue;
                String at = s.split("=")[1];
                try {
                    return ArtifactType.valueOf((String)at);
                }
                catch (IllegalArgumentException e) {
                    throw new BadRequestException("Unsupported artifact type: " + at);
                }
            }
        }
        if (contentType != null && contentType.contains("x-proto")) {
            return ArtifactType.PROTOBUF;
        }
        if (contentType != null && contentType.contains("graphql")) {
            return ArtifactType.GRAPHQL;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ArtifactType discoverType(ContentHandle content, String contentType) throws InvalidArtifactTypeException {
        boolean triedProto = false;
        if (contentType == null || contentType.toLowerCase().contains("proto")) {
            triedProto = true;
            ArtifactType type = ArtifactTypeUtil.tryProto(content);
            if (type != null) {
                return type;
            }
        }
        try {
            JsonNode tree2 = mapper.readTree(content.content());
            if (tree2.has("openapi")) return ArtifactType.OPENAPI;
            if (tree2.has("swagger")) {
                return ArtifactType.OPENAPI;
            }
            if (tree2.has("asyncapi")) {
                return ArtifactType.ASYNCAPI;
            }
            if (!tree2.has("$schema")) throw new InvalidArtifactTypeException("Failed to discover artifact type from JSON content.");
            if (!tree2.get("$schema").asText().contains("json-schema.org")) throw new InvalidArtifactTypeException("Failed to discover artifact type from JSON content.");
            return ArtifactType.JSON;
        }
        catch (Exception tree2) {
            try {
                new Schema.Parser().parse(content.content());
                return ArtifactType.AVRO;
            }
            catch (Exception tree2) {
                ArtifactType type;
                if (!triedProto && (type = ArtifactTypeUtil.tryProto(content)) != null) {
                    return type;
                }
                if (ArtifactTypeUtil.tryGraphQL(content)) {
                    return ArtifactType.GRAPHQL;
                }
                try (InputStream stream = content.stream();){
                    Document xmlDocument = DocumentBuilderAccessor.getDocumentBuilder().parse(stream);
                    Element root = xmlDocument.getDocumentElement();
                    String ns = root.getNamespaceURI();
                    if (ns != null && ns.equals("http://www.w3.org/2001/XMLSchema")) {
                        ArtifactType artifactType = ArtifactType.XSD;
                        return artifactType;
                    }
                    if (ns != null && (ns.equals("http://schemas.xmlsoap.org/wsdl/") || ns.equals("http://www.w3.org/ns/wsdl/"))) {
                        ArtifactType artifactType = ArtifactType.WSDL;
                        return artifactType;
                    }
                    ArtifactType artifactType = ArtifactType.XML;
                    return artifactType;
                }
                catch (Exception exception) {
                    throw new InvalidArtifactTypeException("Failed to discover artifact type from content.");
                }
            }
        }
    }

    private static ArtifactType tryProto(ContentHandle content) {
        try {
            ProtobufFile.toProtoFileElement((String)content.content());
            return ArtifactType.PROTOBUF;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static boolean tryGraphQL(ContentHandle content) {
        try {
            TypeDefinitionRegistry typeRegistry = new SchemaParser().parse(content.content());
            if (typeRegistry != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

