/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.auth;

import io.apicurio.common.apps.multitenancy.MultitenancyProperties;
import io.apicurio.common.apps.multitenancy.TenantContext;
import io.apicurio.registry.auth.AuthConfig;
import io.quarkus.security.identity.SecurityIdentity;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.util.Optional;
import org.eclipse.microprofile.jwt.JsonWebToken;

@ApplicationScoped
public class AdminOverride {
    @Inject
    AuthConfig authConfig;
    @Inject
    SecurityIdentity securityIdentity;
    @Inject
    Instance<JsonWebToken> jsonWebToken;
    @Inject
    TenantContext tenantContext;
    @Inject
    MultitenancyProperties mtProperties;

    public boolean isAdmin() {
        if (this.mtProperties.isMultitenancyEnabled() && this.authConfig.isTenantOwnerAdminEnabled() && this.isTenantOwner()) {
            return true;
        }
        if (!this.authConfig.adminOverrideEnabled) {
            return false;
        }
        if ("token".equals(this.authConfig.adminOverrideFrom)) {
            if ("role".equals(this.authConfig.adminOverrideType)) {
                return this.hasAdminRole();
            }
            if ("claim".equals(this.authConfig.adminOverrideType)) {
                return this.hasAdminClaim();
            }
        }
        return false;
    }

    private boolean isTenantOwner() {
        String tOwner = this.tenantContext.tenantOwner();
        return tOwner != null && this.securityIdentity != null && this.securityIdentity.getPrincipal() != null && tOwner.equals(this.securityIdentity.getPrincipal().getName());
    }

    private boolean hasAdminRole() {
        return this.securityIdentity.hasRole(this.authConfig.adminOverrideRole);
    }

    private boolean hasAdminClaim() {
        Optional claimValue = ((JsonWebToken)this.jsonWebToken.get()).claim(this.authConfig.adminOverrideClaim);
        if (claimValue.isPresent()) {
            return this.authConfig.adminOverrideClaimValue.equals(claimValue.get().toString());
        }
        return false;
    }
}

