/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.downloads;

import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.types.Current;
import io.quarkus.scheduler.Scheduled;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.time.Instant;
import org.slf4j.Logger;

@ApplicationScoped
public class DownloadReaper {
    @Inject
    Logger log;
    @Inject
    @Current
    RegistryStorage storage;

    @Scheduled(delay=2L, concurrentExecution=Scheduled.ConcurrentExecution.SKIP, every="{registry.downloads.reaper.every}")
    void run() {
        try {
            if (this.storage.isReady()) {
                this.log.debug("Running download reaper job at {}", (Object)Instant.now());
                this.reap();
            } else {
                this.log.warn("Storage is not alive. Skipping download reaper job for now.");
            }
        }
        catch (Exception ex) {
            this.log.error("Exception thrown when running download reaper job", (Throwable)ex);
        }
    }

    void reap() {
        this.storage.deleteAllExpiredDownloads();
    }
}

