/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.metrics;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Singleton;

@Singleton
public class CustomMetricsConfiguration {
    @Produces
    @Singleton
    public MeterFilter enableHistogram() {
        final double factor = 1.0E9;
        return new MeterFilter(){

            public DistributionStatisticConfig configure(Meter.Id id, DistributionStatisticConfig config) {
                if (id.getName().startsWith("rest.requests")) {
                    return DistributionStatisticConfig.builder().percentiles(new double[]{0.5, 0.95, 0.99, 0.9995}).serviceLevelObjectives(new double[]{0.1 * factor, 0.25 * factor, 0.5 * factor, 1.0 * factor, 2.0 * factor, 5.0 * factor, 10.0 * factor}).build().merge(config);
                }
                return config;
            }
        };
    }
}

