/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.mt.limits;

import io.apicurio.common.apps.config.Info;
import io.apicurio.common.apps.multitenancy.MultitenancyProperties;
import io.apicurio.common.apps.multitenancy.limits.TenantLimitsConfiguration;
import io.apicurio.common.apps.multitenancy.limits.TenantLimitsConfigurationService;
import io.apicurio.registry.mt.limits.RegistryTenantLimitsConfiguration;
import io.apicurio.tenantmanager.api.datamodel.ApicurioTenant;
import io.apicurio.tenantmanager.api.datamodel.ResourceType;
import io.apicurio.tenantmanager.api.datamodel.TenantResource;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;

@ApplicationScoped
public class RegistryTenantLimitsConfigurationService
implements TenantLimitsConfigurationService {
    @Inject
    Logger logger;
    @Inject
    @ConfigProperty(defaultValue="-1", name="registry.limits.config.max-total-schemas")
    @Info(category="limits", description="Max total schemas", availableSince="2.1.0.Final")
    Long defaultMaxTotalSchemas;
    @Inject
    @ConfigProperty(defaultValue="-1", name="registry.limits.config.max-schema-size-bytes")
    @Info(category="limits", description="Max schema size (bytes)", availableSince="2.2.3.Final")
    Long defaultMaxSchemaSizeBytes;
    @Inject
    @ConfigProperty(defaultValue="-1", name="registry.limits.config.max-artifacts")
    @Info(category="limits", description="Max artifacts", availableSince="2.1.0.Final")
    Long defaultMaxArtifacts;
    @Inject
    @ConfigProperty(defaultValue="-1", name="registry.limits.config.max-versions-per-artifact")
    @Info(category="limits", description="Max versions per artifacts", availableSince="2.1.0.Final")
    Long defaultMaxVersionsPerArtifact;
    @Inject
    @ConfigProperty(defaultValue="-1", name="registry.limits.config.max-artifact-properties")
    @Info(category="limits", description="Max artifact properties", availableSince="2.1.0.Final")
    Long defaultMaxArtifactProperties;
    @Inject
    @ConfigProperty(defaultValue="-1", name="registry.limits.config.max-property-key-size")
    @Info(category="limits", description="Max artifact property key size", availableSince="2.1.0.Final")
    Long defaultMaxPropertyKeyBytesSize;
    @Inject
    @ConfigProperty(defaultValue="-1", name="registry.limits.config.max-property-value-size")
    @Info(category="limits", description="Max artifact property value size", availableSince="2.1.0.Final")
    Long defaultMaxPropertyValueBytesSize;
    @Inject
    @ConfigProperty(defaultValue="-1", name="registry.limits.config.max-artifact-labels")
    @Info(category="limits", description="Max artifact labels", availableSince="2.2.3.Final")
    Long defaultMaxArtifactLabels;
    @Inject
    @ConfigProperty(defaultValue="-1", name="registry.limits.config.max-label-size")
    @Info(category="limits", description="Max artifact label size", availableSince="2.1.0.Final")
    Long defaultMaxLabelBytesSize;
    @Inject
    @ConfigProperty(defaultValue="-1", name="registry.limits.config.max-name-length")
    @Info(category="limits", description="Max artifact name length", availableSince="2.1.0.Final")
    Long defaultMaxNameLength;
    @Inject
    @ConfigProperty(defaultValue="-1", name="registry.limits.config.max-description-length")
    @Info(category="limits", description="Max artifact description length", availableSince="2.1.0.Final")
    Long defaultMaxDescriptionLength;
    @Inject
    @ConfigProperty(defaultValue="-1", name="registry.limits.config.max-requests-per-second")
    @Info(category="limits", description="Max artifact requests per second", availableSince="2.2.3.Final")
    Long defaultMaxRequestsPerSecond;
    @Inject
    MultitenancyProperties mtProperties;
    private boolean isConfigured = true;
    private RegistryTenantLimitsConfiguration defaultLimitsConfiguration;

    @PostConstruct
    public void postConstruct() {
        if (!this.mtProperties.isMultitenancyEnabled() && this.defaultMaxTotalSchemas < 0L && this.defaultMaxSchemaSizeBytes < 0L && this.defaultMaxArtifacts < 0L && this.defaultMaxVersionsPerArtifact < 0L && this.defaultMaxArtifactProperties < 0L && this.defaultMaxPropertyKeyBytesSize < 0L && this.defaultMaxPropertyValueBytesSize < 0L && this.defaultMaxArtifactLabels < 0L && this.defaultMaxLabelBytesSize < 0L && this.defaultMaxNameLength < 0L && this.defaultMaxDescriptionLength < 0L && this.defaultMaxRequestsPerSecond < 0L) {
            this.isConfigured = false;
        }
        RegistryTenantLimitsConfiguration c = new RegistryTenantLimitsConfiguration();
        c.setMaxTotalSchemasCount(this.defaultMaxTotalSchemas);
        c.setMaxSchemaSizeBytes(this.defaultMaxSchemaSizeBytes);
        c.setMaxArtifactsCount(this.defaultMaxArtifacts);
        c.setMaxVersionsPerArtifactCount(this.defaultMaxVersionsPerArtifact);
        c.setMaxArtifactPropertiesCount(this.defaultMaxArtifactProperties);
        c.setMaxPropertyKeySizeBytes(this.defaultMaxPropertyKeyBytesSize);
        c.setMaxPropertyValueSizeBytes(this.defaultMaxPropertyValueBytesSize);
        c.setMaxArtifactLabelsCount(this.defaultMaxArtifactLabels);
        c.setMaxLabelSizeBytes(this.defaultMaxLabelBytesSize);
        c.setMaxArtifactNameLengthChars(this.defaultMaxNameLength);
        c.setMaxArtifactDescriptionLengthChars(this.defaultMaxDescriptionLength);
        c.setMaxRequestsPerSecondCount(this.defaultMaxRequestsPerSecond);
        this.defaultLimitsConfiguration = c;
    }

    public boolean isConfigured() {
        return this.isConfigured;
    }

    public TenantLimitsConfiguration defaultConfigurationTenant() {
        return this.defaultLimitsConfiguration;
    }

    public TenantLimitsConfiguration fromTenantMetadata(ApicurioTenant tenantMetadata) {
        RegistryTenantLimitsConfiguration c = new RegistryTenantLimitsConfiguration();
        if (tenantMetadata.getResources() == null || tenantMetadata.getResources().isEmpty()) {
            this.logger.debug("Tenant has no resources config, using default tenant limits config");
            return this.defaultLimitsConfiguration;
        }
        Map<String, TenantResource> config = tenantMetadata.getResources().stream().collect(Collectors.toMap(tr -> tr.getType(), tr -> tr));
        block28: for (String type : ResourceType.values()) {
            Long limit = Optional.ofNullable(config.get(type)).map(TenantResource::getLimit).orElse(null);
            switch (type) {
                case "MAX_TOTAL_SCHEMAS_COUNT": {
                    c.setMaxTotalSchemasCount(limit == null ? this.defaultMaxTotalSchemas : limit);
                    continue block28;
                }
                case "MAX_SCHEMA_SIZE_BYTES": {
                    c.setMaxSchemaSizeBytes(limit == null ? this.defaultMaxSchemaSizeBytes : limit);
                    continue block28;
                }
                case "MAX_ARTIFACTS_COUNT": {
                    c.setMaxArtifactsCount(limit == null ? this.defaultMaxArtifacts : limit);
                    continue block28;
                }
                case "MAX_VERSIONS_PER_ARTIFACT_COUNT": {
                    c.setMaxVersionsPerArtifactCount(limit == null ? this.defaultMaxVersionsPerArtifact : limit);
                    continue block28;
                }
                case "MAX_ARTIFACT_PROPERTIES_COUNT": {
                    c.setMaxArtifactPropertiesCount(limit == null ? this.defaultMaxArtifactProperties : limit);
                    continue block28;
                }
                case "MAX_PROPERTY_KEY_SIZE_BYTES": {
                    c.setMaxPropertyKeySizeBytes(limit == null ? this.defaultMaxPropertyKeyBytesSize : limit);
                    continue block28;
                }
                case "MAX_PROPERTY_VALUE_SIZE_BYTES": {
                    c.setMaxPropertyValueSizeBytes(limit == null ? this.defaultMaxPropertyValueBytesSize : limit);
                    continue block28;
                }
                case "MAX_ARTIFACT_LABELS_COUNT": {
                    c.setMaxArtifactLabelsCount(limit == null ? this.defaultMaxArtifactLabels : limit);
                    continue block28;
                }
                case "MAX_LABEL_SIZE_BYTES": {
                    c.setMaxLabelSizeBytes(limit == null ? this.defaultMaxLabelBytesSize : limit);
                    continue block28;
                }
                case "MAX_ARTIFACT_NAME_LENGTH_CHARS": {
                    c.setMaxArtifactNameLengthChars(limit == null ? this.defaultMaxNameLength : limit);
                    continue block28;
                }
                case "MAX_ARTIFACT_DESCRIPTION_LENGTH_CHARS": {
                    c.setMaxArtifactDescriptionLengthChars(limit == null ? this.defaultMaxDescriptionLength : limit);
                    continue block28;
                }
                case "MAX_REQUESTS_PER_SECOND_COUNT": {
                    c.setMaxRequestsPerSecondCount(limit == null ? this.defaultMaxRequestsPerSecond : limit);
                    continue block28;
                }
            }
            this.logger.error("Resource Type unhandled " + type);
        }
        return c;
    }
}

