/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.mt.limits;

import io.apicurio.common.apps.multitenancy.TenantContext;
import io.apicurio.common.apps.multitenancy.limits.TenantLimitsService;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.mt.limits.LimitsCheckResult;
import io.apicurio.registry.mt.limits.RegistryTenantLimitsConfiguration;
import io.apicurio.registry.storage.dto.EditableArtifactMetaDataDto;
import io.apicurio.registry.storage.metrics.StorageMetricsStore;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.function.Function;
import org.slf4j.Logger;

@ApplicationScoped
public class RegistryTenantLimitsService
implements TenantLimitsService {
    private static final String MAX_TOTAL_SCHEMAS_EXCEEDED_MSG = "Maximum number of artifact versions exceeded";
    private static final String MAX_SCHEMA_SIZE_EXCEEDED_MSG = "Maximum size of artifact version exceeded";
    private static final String MAX_ARTIFACTS_EXCEEDED_MSG = "Maximum number of artifacts exceeded";
    private static final String MAX_VERSIONS_PER_ARTIFACT_EXCEEDED_MSG = "Maximum number of versions exceeded for this artifact";
    private static final String MAX_NAME_LENGTH_EXCEEDED_MSG = "Maximum artifact name length exceeded";
    private static final String MAX_DESC_LENGTH_EXCEEDED_MSG = "Maximum artifact description length exceeded";
    private static final String MAX_LABELS_EXCEEDED_MSG = "Maximum number of labels exceeded for this artifact";
    private static final String MAX_LABEL_SIZE_EXCEEDED_MSG = "Maximum label size exceeded";
    private static final String MAX_PROPERTIES_EXCEEDED_MSG = "Maximum number of properties exceeded for this artifact";
    private static final String MAX_PROP_KEY_SIZE_EXCEEDED_MSG = "Maximum property key size exceeded";
    private static final String MAX_PROP_VALUE_SIZE_EXCEEDED_MSG = "Maximum property value size exceeded";
    @Inject
    Logger log;
    @Inject
    TenantContext tenantContext;
    @Inject
    StorageMetricsStore storageMetricsStore;

    private LimitsCheckResult checkTotalSchemas() {
        if (this.isLimitDisabled(RegistryTenantLimitsConfiguration::getMaxTotalSchemasCount)) {
            return LimitsCheckResult.ok();
        }
        long currentTotalSchemas = this.storageMetricsStore.getOrInitializeTotalSchemasCounter();
        if (currentTotalSchemas < ((RegistryTenantLimitsConfiguration)this.tenantContext.limitsConfig()).getMaxTotalSchemasCount()) {
            return LimitsCheckResult.ok();
        }
        this.log.debug("Limit reached, current total schemas {} , max total schemas {}", (Object)currentTotalSchemas, (Object)((RegistryTenantLimitsConfiguration)this.tenantContext.limitsConfig()).getMaxTotalSchemasCount());
        return LimitsCheckResult.disallowed(MAX_TOTAL_SCHEMAS_EXCEEDED_MSG);
    }

    public LimitsCheckResult canCreateArtifact(EditableArtifactMetaDataDto meta, ContentHandle content) {
        LimitsCheckResult mr = this.checkMetaData(meta);
        if (!mr.isAllowed()) {
            return mr;
        }
        LimitsCheckResult tsr = this.checkTotalSchemas();
        if (!tsr.isAllowed()) {
            return tsr;
        }
        LimitsCheckResult ssr = this.checkSchemaSize(content);
        if (!ssr.isAllowed()) {
            return ssr;
        }
        if (this.isLimitDisabled(RegistryTenantLimitsConfiguration::getMaxArtifactsCount)) {
            return LimitsCheckResult.ok();
        }
        long currentArtifacts = this.storageMetricsStore.getOrInitializeArtifactsCounter();
        if (currentArtifacts < ((RegistryTenantLimitsConfiguration)this.tenantContext.limitsConfig()).getMaxArtifactsCount()) {
            return LimitsCheckResult.ok();
        }
        this.log.debug("Limit reached, current artifacts {} , max artifacts allowed {}", (Object)currentArtifacts, (Object)((RegistryTenantLimitsConfiguration)this.tenantContext.limitsConfig()).getMaxArtifactsCount());
        return LimitsCheckResult.disallowed(MAX_ARTIFACTS_EXCEEDED_MSG);
    }

    private LimitsCheckResult checkSchemaSize(ContentHandle content) {
        if (this.isLimitDisabled(RegistryTenantLimitsConfiguration::getMaxSchemaSizeBytes) || content == null) {
            return LimitsCheckResult.ok();
        }
        int size = content.getSizeBytes();
        if ((long)size <= ((RegistryTenantLimitsConfiguration)this.tenantContext.limitsConfig()).getMaxSchemaSizeBytes()) {
            return LimitsCheckResult.ok();
        }
        this.log.debug("Limit reached, schema size is {} , max schema size is {}", (Object)size, (Object)((RegistryTenantLimitsConfiguration)this.tenantContext.limitsConfig()).getMaxSchemaSizeBytes());
        return LimitsCheckResult.disallowed(MAX_SCHEMA_SIZE_EXCEEDED_MSG);
    }

    public LimitsCheckResult canCreateArtifactVersion(String groupId, String artifactId, EditableArtifactMetaDataDto meta, ContentHandle content) {
        LimitsCheckResult mr = this.checkMetaData(meta);
        if (!mr.isAllowed()) {
            return mr;
        }
        LimitsCheckResult tsr = this.checkTotalSchemas();
        if (!tsr.isAllowed()) {
            return tsr;
        }
        LimitsCheckResult ssr = this.checkSchemaSize(content);
        if (!ssr.isAllowed()) {
            return ssr;
        }
        if (this.isLimitDisabled(RegistryTenantLimitsConfiguration::getMaxVersionsPerArtifactCount)) {
            return LimitsCheckResult.ok();
        }
        long currentArtifactVersions = this.storageMetricsStore.getOrInitializeArtifactVersionsCounter(groupId, artifactId);
        if (currentArtifactVersions < ((RegistryTenantLimitsConfiguration)this.tenantContext.limitsConfig()).getMaxVersionsPerArtifactCount()) {
            return LimitsCheckResult.ok();
        }
        this.log.debug("Limit reached, current versions per artifact for artifact {}/{} {} , max versions per artifacts allowed {}", new Object[]{groupId, artifactId, currentArtifactVersions, ((RegistryTenantLimitsConfiguration)this.tenantContext.limitsConfig()).getMaxVersionsPerArtifactCount()});
        return LimitsCheckResult.disallowed(MAX_VERSIONS_PER_ARTIFACT_EXCEEDED_MSG);
    }

    public void artifactCreated() {
        this.storageMetricsStore.incrementTotalSchemasCounter();
        this.storageMetricsStore.incrementArtifactsCounter();
    }

    public void artifactVersionCreated(String groupId, String artifactId) {
        this.storageMetricsStore.incrementTotalSchemasCounter();
        this.storageMetricsStore.incrementArtifactVersionsCounter(groupId, artifactId);
    }

    public void artifactDeleted() {
        this.storageMetricsStore.resetTotalSchemasCounter();
        this.storageMetricsStore.resetArtifactsCounter();
    }

    public void artifactVersionDeleted(String groupId, String artifactId) {
        this.storageMetricsStore.resetTotalSchemasCounter();
        this.storageMetricsStore.resetArtifactVersionsCounter(groupId, artifactId);
    }

    public LimitsCheckResult checkMetaData(EditableArtifactMetaDataDto meta) {
        if (meta == null || (RegistryTenantLimitsConfiguration)this.tenantContext.limitsConfig() == null) {
            return LimitsCheckResult.ok();
        }
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (meta.getName() != null && this.isLimitEnabled(RegistryTenantLimitsConfiguration::getMaxArtifactNameLengthChars) && (long)meta.getName().length() > ((RegistryTenantLimitsConfiguration)this.tenantContext.limitsConfig()).getMaxArtifactNameLengthChars()) {
            errorMessages.add(MAX_NAME_LENGTH_EXCEEDED_MSG);
        }
        if (meta.getDescription() != null && this.isLimitEnabled(RegistryTenantLimitsConfiguration::getMaxArtifactDescriptionLengthChars) && (long)meta.getDescription().length() > ((RegistryTenantLimitsConfiguration)this.tenantContext.limitsConfig()).getMaxArtifactDescriptionLengthChars()) {
            errorMessages.add(MAX_DESC_LENGTH_EXCEEDED_MSG);
        }
        if (meta.getLabels() != null) {
            if (this.isLimitEnabled(RegistryTenantLimitsConfiguration::getMaxArtifactLabelsCount) && (long)meta.getLabels().size() > ((RegistryTenantLimitsConfiguration)this.tenantContext.limitsConfig()).getMaxArtifactLabelsCount()) {
                errorMessages.add(MAX_LABELS_EXCEEDED_MSG);
            } else if (this.isLimitEnabled(RegistryTenantLimitsConfiguration::getMaxLabelSizeBytes)) {
                meta.getLabels().forEach(l -> {
                    if ((long)l.getBytes(StandardCharsets.UTF_8).length > ((RegistryTenantLimitsConfiguration)this.tenantContext.limitsConfig()).getMaxLabelSizeBytes()) {
                        errorMessages.add(MAX_LABEL_SIZE_EXCEEDED_MSG);
                    }
                });
            }
        }
        if (meta.getProperties() != null) {
            if (this.isLimitEnabled(RegistryTenantLimitsConfiguration::getMaxArtifactPropertiesCount) && (long)meta.getProperties().size() > ((RegistryTenantLimitsConfiguration)this.tenantContext.limitsConfig()).getMaxArtifactPropertiesCount()) {
                errorMessages.add(MAX_PROPERTIES_EXCEEDED_MSG);
            } else if (this.isLimitEnabled(RegistryTenantLimitsConfiguration::getMaxPropertyKeySizeBytes) || this.isLimitEnabled(RegistryTenantLimitsConfiguration::getMaxPropertyValueSizeBytes)) {
                meta.getProperties().entrySet().forEach(e -> {
                    if (this.isLimitEnabled(RegistryTenantLimitsConfiguration::getMaxPropertyKeySizeBytes) && (long)((String)e.getKey()).length() > ((RegistryTenantLimitsConfiguration)this.tenantContext.limitsConfig()).getMaxPropertyKeySizeBytes()) {
                        errorMessages.add(MAX_PROP_KEY_SIZE_EXCEEDED_MSG);
                    }
                    if (this.isLimitEnabled(RegistryTenantLimitsConfiguration::getMaxPropertyValueSizeBytes) && (long)((String)e.getValue()).length() > ((RegistryTenantLimitsConfiguration)this.tenantContext.limitsConfig()).getMaxPropertyValueSizeBytes()) {
                        errorMessages.add(MAX_PROP_VALUE_SIZE_EXCEEDED_MSG);
                    }
                });
            }
        }
        if (errorMessages.isEmpty()) {
            return LimitsCheckResult.ok();
        }
        return LimitsCheckResult.disallowed(String.join((CharSequence)", ", errorMessages));
    }

    private boolean isLimitEnabled(Function<RegistryTenantLimitsConfiguration, Long> limitGetter) {
        Long limit;
        return (RegistryTenantLimitsConfiguration)this.tenantContext.limitsConfig() != null && (limit = limitGetter.apply((RegistryTenantLimitsConfiguration)this.tenantContext.limitsConfig())) != null && limit >= 0L;
    }

    private boolean isLimitDisabled(Function<RegistryTenantLimitsConfiguration, Long> limitGetter) {
        return !this.isLimitEnabled(limitGetter);
    }
}

