/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.v2;

import com.google.common.hash.Hashing;
import io.apicurio.common.apps.logging.Logged;
import io.apicurio.common.apps.logging.audit.Audited;
import io.apicurio.registry.auth.Authorized;
import io.apicurio.registry.auth.AuthorizedLevel;
import io.apicurio.registry.auth.AuthorizedStyle;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.metrics.health.liveness.ResponseErrorLivenessCheck;
import io.apicurio.registry.metrics.health.readiness.ResponseTimeoutReadinessCheck;
import io.apicurio.registry.rest.HeadersHack;
import io.apicurio.registry.rest.MissingRequiredParameterException;
import io.apicurio.registry.rest.ParametersConflictException;
import io.apicurio.registry.rest.RestConfig;
import io.apicurio.registry.rest.v2.GroupsResource;
import io.apicurio.registry.rest.v2.V2ApiUtil;
import io.apicurio.registry.rest.v2.beans.ArtifactContent;
import io.apicurio.registry.rest.v2.beans.ArtifactMetaData;
import io.apicurio.registry.rest.v2.beans.ArtifactOwner;
import io.apicurio.registry.rest.v2.beans.ArtifactReference;
import io.apicurio.registry.rest.v2.beans.ArtifactSearchResults;
import io.apicurio.registry.rest.v2.beans.Comment;
import io.apicurio.registry.rest.v2.beans.CreateGroupMetaData;
import io.apicurio.registry.rest.v2.beans.EditableMetaData;
import io.apicurio.registry.rest.v2.beans.GroupMetaData;
import io.apicurio.registry.rest.v2.beans.GroupSearchResults;
import io.apicurio.registry.rest.v2.beans.IfExists;
import io.apicurio.registry.rest.v2.beans.NewComment;
import io.apicurio.registry.rest.v2.beans.Rule;
import io.apicurio.registry.rest.v2.beans.SortBy;
import io.apicurio.registry.rest.v2.beans.SortOrder;
import io.apicurio.registry.rest.v2.beans.UpdateState;
import io.apicurio.registry.rest.v2.beans.VersionMetaData;
import io.apicurio.registry.rest.v2.beans.VersionSearchResults;
import io.apicurio.registry.rest.v2.shared.CommonResourceOperations;
import io.apicurio.registry.rules.RuleApplicationType;
import io.apicurio.registry.rules.RulesService;
import io.apicurio.registry.storage.ArtifactAlreadyExistsException;
import io.apicurio.registry.storage.ArtifactNotFoundException;
import io.apicurio.registry.storage.InvalidArtifactIdException;
import io.apicurio.registry.storage.InvalidGroupIdException;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.VersionNotFoundException;
import io.apicurio.registry.storage.dto.ArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.ArtifactOwnerDto;
import io.apicurio.registry.storage.dto.ArtifactReferenceDto;
import io.apicurio.registry.storage.dto.ArtifactSearchResultsDto;
import io.apicurio.registry.storage.dto.ArtifactVersionMetaDataDto;
import io.apicurio.registry.storage.dto.CommentDto;
import io.apicurio.registry.storage.dto.EditableArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.GroupMetaDataDto;
import io.apicurio.registry.storage.dto.GroupSearchResultsDto;
import io.apicurio.registry.storage.dto.OrderBy;
import io.apicurio.registry.storage.dto.OrderDirection;
import io.apicurio.registry.storage.dto.RuleConfigurationDto;
import io.apicurio.registry.storage.dto.SearchFilter;
import io.apicurio.registry.storage.dto.StoredArtifactDto;
import io.apicurio.registry.storage.dto.VersionSearchResultsDto;
import io.apicurio.registry.types.ArtifactState;
import io.apicurio.registry.types.Current;
import io.apicurio.registry.types.ReferenceType;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProviderFactory;
import io.apicurio.registry.util.ArtifactIdGenerator;
import io.apicurio.registry.util.ArtifactTypeUtil;
import io.apicurio.registry.util.ContentTypeUtil;
import io.apicurio.registry.utils.ArtifactIdValidator;
import io.apicurio.registry.utils.IoUtil;
import io.apicurio.registry.utils.JAXRSClientUtil;
import io.quarkus.security.identity.SecurityIdentity;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.interceptor.Interceptors;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotAllowedException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jose4j.base64url.Base64;

@ApplicationScoped
@Interceptors(value={ResponseErrorLivenessCheck.class, ResponseTimeoutReadinessCheck.class})
@Logged
public class GroupsResourceImpl
implements GroupsResource {
    private static final String EMPTY_CONTENT_ERROR_MESSAGE = "Empty content is not allowed.";
    private static final Integer GET_GROUPS_LIMIT = 1000;
    @Inject
    @Current
    RegistryStorage storage;
    @Inject
    RulesService rulesService;
    @Inject
    ArtifactIdGenerator idGenerator;
    @Inject
    ArtifactTypeUtilProviderFactory factory;
    @Context
    HttpServletRequest request;
    @Inject
    RestConfig restConfig;
    @Inject
    SecurityIdentity securityIdentity;
    @Inject
    CommonResourceOperations common;

    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public Response getLatestArtifact(String groupId, String artifactId, Boolean dereference) {
        ArtifactMetaDataDto metaData;
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        if (dereference == null) {
            dereference = Boolean.FALSE;
        }
        if (ArtifactState.DISABLED.equals((Object)(metaData = this.storage.getArtifactMetaData(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId)).getState())) {
            throw new ArtifactNotFoundException(groupId, artifactId);
        }
        StoredArtifactDto artifact = this.storage.getArtifact(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId);
        MediaType contentType = this.factory.getArtifactMediaType(metaData.getType());
        ContentHandle contentToReturn = artifact.getContent();
        Response.ResponseBuilder builder = Response.ok((Object)contentToReturn, (MediaType)contentType);
        this.checkIfDeprecated(metaData::getState, groupId, artifactId, metaData.getVersion(), builder);
        return builder.build();
    }

    @Audited(extractParameters={"0", "group_id", "1", "artifact_id", "2", "version", "3", "name", "4", "name_encoded", "5", "description", "6", "description_encoded"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public ArtifactMetaData updateArtifact(String groupId, String artifactId, String xRegistryVersion, String xRegistryName, String xRegistryNameEncoded, String xRegistryDescription, String xRegistryDescriptionEncoded, InputStream data) {
        return this.updateArtifactWithRefs(groupId, artifactId, xRegistryVersion, xRegistryName, xRegistryNameEncoded, xRegistryDescription, xRegistryDescriptionEncoded, data, Collections.emptyList());
    }

    @Audited(extractParameters={"0", "group_id", "1", "artifact_id", "2", "version", "3", "name", "4", "name_encoded", "5", "description", "6", "description_encoded"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public ArtifactMetaData updateArtifact(String groupId, String artifactId, String xRegistryVersion, String xRegistryName, String xRegistryNameEncoded, String xRegistryDescription, String xRegistryDescriptionEncoded, ArtifactContent data) {
        GroupsResourceImpl.requireParameter("content", data.getContent());
        return this.updateArtifactWithRefs(groupId, artifactId, xRegistryVersion, xRegistryName, xRegistryNameEncoded, xRegistryDescription, xRegistryDescriptionEncoded, IoUtil.toStream((String)data.getContent()), data.getReferences());
    }

    public List<ArtifactReference> getArtifactVersionReferences(String groupId, String artifactId, String version, ReferenceType refType) {
        if (refType == null || refType == ReferenceType.OUTBOUND) {
            return this.storage.getArtifactVersion(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, version).getReferences().stream().map(V2ApiUtil::referenceDtoToReference).collect(Collectors.toList());
        }
        return this.storage.getInboundArtifactReferences(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, version).stream().map(V2ApiUtil::referenceDtoToReference).collect(Collectors.toList());
    }

    private ArtifactMetaData updateArtifactWithRefs(String groupId, String artifactId, String xRegistryVersion, String xRegistryName, String xRegistryNameEncoded, String xRegistryDescription, String xRegistryDescriptionEncoded, InputStream data, List<ArtifactReference> references) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.maxOneOf("X-Registry-Name", xRegistryName, "X-Registry-Name-Encoded", xRegistryNameEncoded);
        GroupsResourceImpl.maxOneOf("X-Registry-Description", xRegistryDescription, "X-Registry-Description-Encoded", xRegistryDescriptionEncoded);
        String artifactName = GroupsResourceImpl.getOneOf(xRegistryName, GroupsResourceImpl.decode(xRegistryNameEncoded));
        String artifactDescription = GroupsResourceImpl.getOneOf(xRegistryDescription, GroupsResourceImpl.decode(xRegistryDescriptionEncoded));
        ContentHandle content = ContentHandle.create((InputStream)data);
        if (content.bytes().length == 0) {
            throw new BadRequestException(EMPTY_CONTENT_ERROR_MESSAGE);
        }
        return this.updateArtifactInternal(groupId, artifactId, xRegistryVersion, artifactName, artifactDescription, content, this.getContentType(), references);
    }

    @Audited(extractParameters={"0", "group_id", "1", "artifact_id"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void deleteArtifact(String groupId, String artifactId) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        this.storage.deleteArtifact(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId);
    }

    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public ArtifactMetaData getArtifactMetaData(String groupId, String artifactId) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        ArtifactMetaDataDto dto = this.storage.getArtifactMetaData(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId);
        return V2ApiUtil.dtoToMetaData(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, dto.getType(), dto);
    }

    @Audited(extractParameters={"0", "group_id", "1", "artifact_id", "2", "editable_metadata"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void updateArtifactMetaData(String groupId, String artifactId, EditableMetaData data) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        if (data.getProperties() != null) {
            data.getProperties().forEach((k, v) -> GroupsResourceImpl.requireParameter("property value", v));
        }
        EditableArtifactMetaDataDto dto = new EditableArtifactMetaDataDto();
        dto.setName(data.getName());
        dto.setDescription(data.getDescription());
        dto.setLabels(data.getLabels());
        dto.setProperties(data.getProperties());
        this.storage.updateArtifactMetaData(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, dto);
    }

    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public ArtifactOwner getArtifactOwner(String groupId, String artifactId) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        ArtifactMetaDataDto dto = this.storage.getArtifactMetaData(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId);
        ArtifactOwner owner = new ArtifactOwner();
        owner.setOwner(dto.getCreatedBy());
        return owner;
    }

    @Audited(extractParameters={"0", "group_id", "1", "artifact_id", "2", "owner"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.AdminOrOwner)
    public void updateArtifactOwner(String groupId, String artifactId, ArtifactOwner data) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("data", data);
        if (data.getOwner().isEmpty()) {
            throw new MissingRequiredParameterException("Missing required owner");
        }
        ArtifactOwnerDto dto = new ArtifactOwnerDto(data.getOwner());
        this.storage.updateArtifactOwner(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, dto);
    }

    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public GroupMetaData getGroupById(String groupId) {
        GroupMetaDataDto group = this.storage.getGroupMetaData(groupId);
        return V2ApiUtil.groupDtoToGroup(group);
    }

    @Authorized(style=AuthorizedStyle.GroupOnly, level=AuthorizedLevel.Write)
    public void deleteGroupById(String groupId) {
        this.storage.deleteGroup(groupId);
    }

    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Read)
    public GroupSearchResults listGroups(BigInteger limit, BigInteger offset, SortOrder order, SortBy orderby) {
        if (orderby == null) {
            orderby = SortBy.name;
        }
        if (offset == null) {
            offset = BigInteger.valueOf(0L);
        }
        if (limit == null) {
            limit = BigInteger.valueOf(20L);
        }
        OrderBy oBy = OrderBy.valueOf(orderby.name());
        OrderDirection oDir = order == null || order == SortOrder.asc ? OrderDirection.asc : OrderDirection.desc;
        Set<SearchFilter> filters = Collections.emptySet();
        GroupSearchResultsDto resultsDto = this.storage.searchGroups(filters, oBy, oDir, offset.intValue(), limit.intValue());
        return V2ApiUtil.dtoToSearchResults(resultsDto);
    }

    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Write)
    public GroupMetaData createGroup(CreateGroupMetaData data) {
        GroupMetaDataDto.GroupMetaDataDtoBuilder group = GroupMetaDataDto.builder().groupId(data.getId()).description(data.getDescription()).properties(data.getProperties());
        String user = this.securityIdentity.getPrincipal().getName();
        group.createdBy(user).createdOn(new Date().getTime());
        this.storage.createGroup(group.build());
        return V2ApiUtil.groupDtoToGroup(this.storage.getGroupMetaData(data.getId()));
    }

    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public VersionMetaData getArtifactVersionMetaDataByContent(String groupId, String artifactId, Boolean canonical, ArtifactContent artifactContent) {
        return this.getArtifactVersionMetaDataByContent(groupId, artifactId, canonical, IoUtil.toStream((String)artifactContent.getContent()), artifactContent.getReferences());
    }

    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public VersionMetaData getArtifactVersionMetaDataByContent(String groupId, String artifactId, Boolean canonical, InputStream data) {
        return this.getArtifactVersionMetaDataByContent(groupId, artifactId, canonical, data, Collections.emptyList());
    }

    private VersionMetaData getArtifactVersionMetaDataByContent(String groupId, String artifactId, Boolean canonical, InputStream data, List<ArtifactReference> artifactReferences) {
        ContentHandle content;
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        if (canonical == null) {
            canonical = Boolean.FALSE;
        }
        if ((content = ContentHandle.create((InputStream)data)).bytes().length == 0) {
            throw new BadRequestException(EMPTY_CONTENT_ERROR_MESSAGE);
        }
        if (ContentTypeUtil.isApplicationYaml(this.getContentType())) {
            content = ContentTypeUtil.yamlToJson(content);
        }
        List<ArtifactReferenceDto> artifactReferenceDtos = this.toReferenceDtos(artifactReferences);
        ArtifactVersionMetaDataDto dto = this.storage.getArtifactVersionMetaData(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, canonical, content, artifactReferenceDtos);
        return V2ApiUtil.dtoToVersionMetaData(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, dto.getType(), dto);
    }

    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public List<RuleType> listArtifactRules(String groupId, String artifactId) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        return this.storage.getArtifactRules(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId);
    }

    @Audited(extractParameters={"0", "group_id", "1", "artifact_id", "2", "rule"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void createArtifactRule(String groupId, String artifactId, Rule data) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        RuleConfigurationDto config = new RuleConfigurationDto();
        config.setConfiguration(data.getConfig());
        if (!this.storage.isArtifactExists(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId)) {
            throw new ArtifactNotFoundException(groupId, artifactId);
        }
        this.storage.createArtifactRule(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, data.getType(), config);
    }

    @Audited(extractParameters={"0", "group_id", "1", "artifact_id"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void deleteArtifactRules(String groupId, String artifactId) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        this.storage.deleteArtifactRules(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId);
    }

    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public Rule getArtifactRuleConfig(String groupId, String artifactId, RuleType rule) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("rule", rule);
        RuleConfigurationDto dto = this.storage.getArtifactRule(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, rule);
        Rule rval = new Rule();
        rval.setConfig(dto.getConfiguration());
        rval.setType(rule);
        return rval;
    }

    @Audited(extractParameters={"0", "group_id", "1", "artifact_id", "2", "rule_type", "3", "rule"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public Rule updateArtifactRuleConfig(String groupId, String artifactId, RuleType rule, Rule data) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("rule", rule);
        RuleConfigurationDto dto = new RuleConfigurationDto(data.getConfig());
        this.storage.updateArtifactRule(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, rule, dto);
        Rule rval = new Rule();
        rval.setType(rule);
        rval.setConfig(data.getConfig());
        return rval;
    }

    @Audited(extractParameters={"0", "group_id", "1", "artifact_id", "2", "rule_type"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void deleteArtifactRule(String groupId, String artifactId, RuleType rule) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("rule", rule);
        this.storage.deleteArtifactRule(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, rule);
    }

    @Audited(extractParameters={"0", "group_id", "1", "artifact_id", "2", "update_state"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void updateArtifactState(String groupId, String artifactId, UpdateState data) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("body.state", data.getState());
        this.storage.updateArtifactState(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, data.getState());
    }

    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void testUpdateArtifact(String groupId, String artifactId, InputStream data) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        ContentHandle content = ContentHandle.create((InputStream)data);
        if (content.bytes().length == 0) {
            throw new BadRequestException(EMPTY_CONTENT_ERROR_MESSAGE);
        }
        String ct = this.getContentType();
        if (ContentTypeUtil.isApplicationYaml(ct)) {
            content = ContentTypeUtil.yamlToJson(content);
        }
        String artifactType = this.lookupArtifactType(groupId, artifactId);
        this.rulesService.applyRules(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, artifactType, content, RuleApplicationType.UPDATE, Collections.emptyList(), Collections.emptyMap());
    }

    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public Response getArtifactVersion(String groupId, String artifactId, String version, Boolean dereference) {
        ArtifactVersionMetaDataDto metaData;
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("version", version);
        if (dereference == null) {
            dereference = Boolean.FALSE;
        }
        if (ArtifactState.DISABLED.equals((Object)(metaData = this.storage.getArtifactVersionMetaData(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, version)).getState())) {
            throw new VersionNotFoundException(groupId, artifactId, version);
        }
        StoredArtifactDto artifact = this.storage.getArtifactVersion(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, version);
        MediaType contentType = this.factory.getArtifactMediaType(metaData.getType());
        ContentHandle contentToReturn = artifact.getContent();
        Response.ResponseBuilder builder = Response.ok((Object)contentToReturn, (MediaType)contentType);
        this.checkIfDeprecated(metaData::getState, groupId, artifactId, version, builder);
        return builder.build();
    }

    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void deleteArtifactVersion(String groupId, String artifactId, String version) {
        if (!this.restConfig.isArtifactVersionDeletionEnabled()) {
            throw new NotAllowedException("Artifact version deletion operation is not enabled.", "GET", (String[])null);
        }
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("version", version);
        this.storage.deleteArtifactVersion(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, version);
    }

    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public VersionMetaData getArtifactVersionMetaData(String groupId, String artifactId, String version) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("version", version);
        ArtifactVersionMetaDataDto dto = this.storage.getArtifactVersionMetaData(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, version);
        return V2ApiUtil.dtoToVersionMetaData(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, dto.getType(), dto);
    }

    @Audited(extractParameters={"0", "group_id", "1", "artifact_id", "2", "version", "3", "editable_metadata"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void updateArtifactVersionMetaData(String groupId, String artifactId, String version, EditableMetaData data) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("version", version);
        if (data.getProperties() != null) {
            data.getProperties().forEach((k, v) -> GroupsResourceImpl.requireParameter("property value", v));
        }
        EditableArtifactMetaDataDto dto = new EditableArtifactMetaDataDto();
        dto.setName(data.getName());
        dto.setDescription(data.getDescription());
        dto.setLabels(data.getLabels());
        dto.setProperties(data.getProperties());
        this.storage.updateArtifactVersionMetaData(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, version, dto);
    }

    @Audited(extractParameters={"0", "group_id", "1", "artifact_id", "2", "version"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void deleteArtifactVersionMetaData(String groupId, String artifactId, String version) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("version", version);
        this.storage.deleteArtifactVersionMetaData(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, version);
    }

    @Audited(extractParameters={"0", "group_id", "1", "artifact_id", "2", "version"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public Comment addArtifactVersionComment(String groupId, String artifactId, String version, NewComment data) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("version", version);
        CommentDto newComment = this.storage.createArtifactVersionComment(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, version, data.getValue());
        return V2ApiUtil.commentDtoToComment(newComment);
    }

    @Audited(extractParameters={"0", "group_id", "1", "artifact_id", "2", "version", "3", "comment_id"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void deleteArtifactVersionComment(String groupId, String artifactId, String version, String commentId) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("version", version);
        GroupsResourceImpl.requireParameter("commentId", commentId);
        this.storage.deleteArtifactVersionComment(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, version, commentId);
    }

    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public List<Comment> getArtifactVersionComments(String groupId, String artifactId, String version) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("version", version);
        return this.storage.getArtifactVersionComments(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, version).stream().map(V2ApiUtil::commentDtoToComment).collect(Collectors.toList());
    }

    @Audited(extractParameters={"0", "group_id", "1", "artifact_id", "2", "version", "3", "comment_id"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void updateArtifactVersionComment(String groupId, String artifactId, String version, String commentId, NewComment data) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("version", version);
        GroupsResourceImpl.requireParameter("commentId", commentId);
        GroupsResourceImpl.requireParameter("value", data.getValue());
        this.storage.updateArtifactVersionComment(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, version, commentId, data.getValue());
    }

    @Audited(extractParameters={"0", "group_id", "1", "artifact_id", "2", "version", "3", "update_state"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void updateArtifactVersionState(String groupId, String artifactId, String version, UpdateState data) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.requireParameter("version", version);
        this.storage.updateArtifactState(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, version, data.getState());
    }

    @Authorized(style=AuthorizedStyle.GroupOnly, level=AuthorizedLevel.Read)
    public ArtifactSearchResults listArtifactsInGroup(String groupId, BigInteger limit, BigInteger offset, SortOrder order, SortBy orderby) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        if (orderby == null) {
            orderby = SortBy.name;
        }
        if (offset == null) {
            offset = BigInteger.valueOf(0L);
        }
        if (limit == null) {
            limit = BigInteger.valueOf(20L);
        }
        OrderBy oBy = OrderBy.valueOf(orderby.name());
        OrderDirection oDir = order == null || order == SortOrder.asc ? OrderDirection.asc : OrderDirection.desc;
        HashSet<SearchFilter> filters = new HashSet<SearchFilter>();
        filters.add(SearchFilter.ofGroup(V2ApiUtil.defaultGroupIdToNull(groupId)));
        ArtifactSearchResultsDto resultsDto = this.storage.searchArtifacts(filters, oBy, oDir, offset.intValue(), limit.intValue());
        return V2ApiUtil.dtoToSearchResults(resultsDto);
    }

    @Audited(extractParameters={"0", "group_id"})
    @Authorized(style=AuthorizedStyle.GroupOnly, level=AuthorizedLevel.Write)
    public void deleteArtifactsInGroup(String groupId) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        this.storage.deleteArtifacts(V2ApiUtil.defaultGroupIdToNull(groupId));
    }

    @Audited(extractParameters={"0", "group_id", "1", "artifact_type", "2", "artifact_id", "3", "version", "4", "if_exists", "5", "canonical", "6", "description", "7", "description_encoded", "8", "name", "9", "name_encoded", "10", "from_url", "11", "artifact_sha"})
    @Authorized(style=AuthorizedStyle.GroupOnly, level=AuthorizedLevel.Write)
    public ArtifactMetaData createArtifact(String groupId, String xRegistryArtifactType, String xRegistryArtifactId, String xRegistryVersion, IfExists ifExists, Boolean canonical, String xRegistryDescription, String xRegistryDescriptionEncoded, String xRegistryName, String xRegistryNameEncoded, String xRegistryContentHash, String xRegistryHashAlgorithm, InputStream data) {
        return this.createArtifactWithRefs(groupId, xRegistryArtifactType, xRegistryArtifactId, xRegistryVersion, ifExists, canonical, xRegistryDescription, xRegistryDescriptionEncoded, xRegistryName, xRegistryNameEncoded, xRegistryContentHash, xRegistryHashAlgorithm, data, Collections.emptyList());
    }

    @Audited(extractParameters={"0", "group_id", "1", "artifact_type", "2", "artifact_id", "3", "version", "4", "if_exists", "5", "canonical", "6", "description", "7", "description_encoded", "8", "name", "9", "name_encoded", "10", "from_url", "11", "artifact_sha"})
    @Authorized(style=AuthorizedStyle.GroupOnly, level=AuthorizedLevel.Write)
    public ArtifactMetaData createArtifact(String groupId, String xRegistryArtifactType, String xRegistryArtifactId, String xRegistryVersion, IfExists ifExists, Boolean canonical, String xRegistryDescription, String xRegistryDescriptionEncoded, String xRegistryName, String xRegistryNameEncoded, String xRegistryContentHash, String xRegistryHashAlgorithm, ArtifactContent data) {
        GroupsResourceImpl.requireParameter("content", data.getContent());
        try (Client client = null;){
            InputStream content;
            try {
                URL url = new URL(data.getContent());
                client = JAXRSClientUtil.getJAXRSClient((boolean)this.restConfig.getDownloadSkipSSLValidation());
                content = this.fetchContentFromURL(client, url.toURI());
            }
            catch (MalformedURLException | URISyntaxException e) {
                content = IoUtil.toStream((String)data.getContent());
            }
            ArtifactMetaData e = this.createArtifactWithRefs(groupId, xRegistryArtifactType, xRegistryArtifactId, xRegistryVersion, ifExists, canonical, xRegistryDescription, xRegistryDescriptionEncoded, xRegistryName, xRegistryNameEncoded, xRegistryContentHash, xRegistryHashAlgorithm, content, data.getReferences());
            return e;
        }
    }

    private InputStream fetchContentFromURL(Client client, URI url) {
        try {
            List contentLengthHeaders = (List)client.target(url).request().head().getHeaders().get((Object)"Content-Length");
            if (contentLengthHeaders == null || contentLengthHeaders.size() < 1) {
                throw new BadRequestException("Requested resource URL does not provide 'Content-Length' in the headers");
            }
            int contentLength = Integer.parseInt(contentLengthHeaders.get(0).toString());
            if (contentLength > this.restConfig.getDownloadMaxSize()) {
                throw new BadRequestException("Requested resource is bigger than " + this.restConfig.getDownloadMaxSize() + " and cannot be downloaded.");
            }
            if (contentLength <= 0) {
                throw new BadRequestException("Requested resource URL is providing 'Content-Length' <= 0.");
            }
            return new BufferedInputStream((InputStream)client.target(url).request().get().readEntity(InputStream.class), contentLength);
        }
        catch (BadRequestException bre) {
            throw bre;
        }
        catch (Exception e) {
            throw new BadRequestException("Errors downloading the artifact content.", (Throwable)e);
        }
    }

    private ArtifactMetaData createArtifactWithRefs(String groupId, String xRegistryArtifactType, String xRegistryArtifactId, String xRegistryVersion, IfExists ifExists, Boolean canonical, String xRegistryDescription, String xRegistryDescriptionEncoded, String xRegistryName, String xRegistryNameEncoded, String xRegistryContentHash, String xRegistryHashAlgorithm, InputStream data, List<ArtifactReference> references) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.maxOneOf("X-Registry-Name", xRegistryName, "X-Registry-Name-Encoded", xRegistryNameEncoded);
        GroupsResourceImpl.maxOneOf("X-Registry-Description", xRegistryDescription, "X-Registry-Description-Encoded", xRegistryDescriptionEncoded);
        String artifactName = GroupsResourceImpl.getOneOf(xRegistryName, GroupsResourceImpl.decode(xRegistryNameEncoded));
        String artifactDescription = GroupsResourceImpl.getOneOf(xRegistryDescription, GroupsResourceImpl.decode(xRegistryDescriptionEncoded));
        if (!ArtifactIdValidator.isGroupIdAllowed((String)groupId)) {
            throw new InvalidGroupIdException("Character % and non ASCII characters are not allowed in group IDs.");
        }
        ContentHandle content = ContentHandle.create((InputStream)data);
        if (content.bytes().length == 0) {
            throw new BadRequestException(EMPTY_CONTENT_ERROR_MESSAGE);
        }
        if (xRegistryContentHash != null) {
            String calculatedSha = null;
            try {
                RegistryHashAlgorithm algorithm = xRegistryHashAlgorithm == null ? RegistryHashAlgorithm.SHA256 : RegistryHashAlgorithm.valueOf(xRegistryHashAlgorithm);
                switch (algorithm) {
                    case MD5: {
                        calculatedSha = Hashing.md5().hashString((CharSequence)content.content(), StandardCharsets.UTF_8).toString();
                        break;
                    }
                    case SHA256: {
                        calculatedSha = Hashing.sha256().hashString((CharSequence)content.content(), StandardCharsets.UTF_8).toString();
                    }
                }
            }
            catch (Exception e) {
                throw new BadRequestException("Requested hash algorithm not supported");
            }
            if (!calculatedSha.equals(xRegistryContentHash.trim())) {
                throw new BadRequestException("Provided Artifact Hash doesn't match with the content");
            }
        }
        boolean fcanonical = canonical == null ? Boolean.FALSE : canonical;
        String ct = this.getContentType();
        try {
            String artifactId = xRegistryArtifactId;
            if (artifactId == null || artifactId.trim().isEmpty()) {
                artifactId = this.idGenerator.generate();
            } else if (!ArtifactIdValidator.isArtifactIdAllowed((String)artifactId)) {
                throw new InvalidArtifactIdException("Character % and non ASCII characters are not allowed in artifact IDs.");
            }
            if (ContentTypeUtil.isApplicationYaml(ct) || ContentTypeUtil.isApplicationCreateExtended(ct) && ContentTypeUtil.isParsableYaml(content)) {
                content = ContentTypeUtil.yamlToJson(content);
            }
            String artifactType = ArtifactTypeUtil.determineArtifactType(content, xRegistryArtifactType, ct, this.factory.getAllArtifactTypes());
            List<ArtifactReferenceDto> referencesAsDtos = this.toReferenceDtos(references);
            Map<String, ContentHandle> resolvedReferences = this.storage.resolveReferences(referencesAsDtos);
            this.rulesService.applyRules(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, artifactType, content, RuleApplicationType.CREATE, references, resolvedReferences);
            String finalArtifactId = artifactId;
            EditableArtifactMetaDataDto metaData = this.getEditableMetaData(artifactName, artifactDescription);
            ArtifactMetaDataDto amd = this.storage.createArtifactWithMetadata(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, xRegistryVersion, artifactType, content, metaData, referencesAsDtos);
            return V2ApiUtil.dtoToMetaData(V2ApiUtil.defaultGroupIdToNull(groupId), finalArtifactId, artifactType, amd);
        }
        catch (ArtifactAlreadyExistsException ex) {
            return this.handleIfExists(groupId, xRegistryArtifactId, xRegistryVersion, ifExists, artifactName, artifactDescription, content, ct, fcanonical, references);
        }
    }

    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public VersionSearchResults listArtifactVersions(String groupId, String artifactId, BigInteger offset, BigInteger limit) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        if (offset == null) {
            offset = BigInteger.valueOf(0L);
        }
        if (limit == null) {
            limit = BigInteger.valueOf(20L);
        }
        VersionSearchResultsDto resultsDto = this.storage.searchVersions(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, offset.intValue(), limit.intValue());
        return V2ApiUtil.dtoToSearchResults(resultsDto);
    }

    @Audited(extractParameters={"0", "group_id", "1", "artifact_id", "2", "version", "3", "name", "4", "description", "5", "description_encoded", "6", "name_encoded"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public VersionMetaData createArtifactVersion(String groupId, String artifactId, String xRegistryVersion, String xRegistryName, String xRegistryDescription, String xRegistryDescriptionEncoded, String xRegistryNameEncoded, InputStream data) {
        return this.createArtifactVersionWithRefs(groupId, artifactId, xRegistryVersion, xRegistryName, xRegistryDescription, xRegistryDescriptionEncoded, xRegistryNameEncoded, data, Collections.emptyList());
    }

    @Audited(extractParameters={"0", "group_id", "1", "artifact_id", "2", "version", "3", "name", "4", "description", "5", "description_encoded", "6", "name_encoded"})
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public VersionMetaData createArtifactVersion(String groupId, String artifactId, String xRegistryVersion, String xRegistryName, String xRegistryDescription, String xRegistryDescriptionEncoded, String xRegistryNameEncoded, ArtifactContent data) {
        GroupsResourceImpl.requireParameter("content", data.getContent());
        return this.createArtifactVersionWithRefs(groupId, artifactId, xRegistryVersion, xRegistryName, xRegistryDescription, xRegistryDescriptionEncoded, xRegistryNameEncoded, IoUtil.toStream((String)data.getContent()), data.getReferences());
    }

    private VersionMetaData createArtifactVersionWithRefs(String groupId, String artifactId, String xRegistryVersion, String xRegistryName, String xRegistryDescription, String xRegistryDescriptionEncoded, String xRegistryNameEncoded, InputStream data, List<ArtifactReference> references) {
        GroupsResourceImpl.requireParameter("groupId", groupId);
        GroupsResourceImpl.requireParameter("artifactId", artifactId);
        GroupsResourceImpl.maxOneOf("X-Registry-Name", xRegistryName, "X-Registry-Name-Encoded", xRegistryNameEncoded);
        GroupsResourceImpl.maxOneOf("X-Registry-Description", xRegistryDescription, "X-Registry-Description-Encoded", xRegistryDescriptionEncoded);
        String artifactName = GroupsResourceImpl.getOneOf(xRegistryName, GroupsResourceImpl.decode(xRegistryNameEncoded));
        String artifactDescription = GroupsResourceImpl.getOneOf(xRegistryDescription, GroupsResourceImpl.decode(xRegistryDescriptionEncoded));
        ContentHandle content = ContentHandle.create((InputStream)data);
        if (content.bytes().length == 0) {
            throw new BadRequestException(EMPTY_CONTENT_ERROR_MESSAGE);
        }
        String ct = this.getContentType();
        if (ContentTypeUtil.isApplicationYaml(ct)) {
            content = ContentTypeUtil.yamlToJson(content);
        }
        List<ArtifactReferenceDto> referencesAsDtos = this.toReferenceDtos(references);
        Map<String, ContentHandle> resolvedReferences = this.storage.resolveReferences(referencesAsDtos);
        String artifactType = this.lookupArtifactType(groupId, artifactId);
        this.rulesService.applyRules(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, artifactType, content, RuleApplicationType.UPDATE, references, resolvedReferences);
        EditableArtifactMetaDataDto metaData = this.getEditableMetaData(artifactName, artifactDescription);
        ArtifactMetaDataDto amd = this.storage.updateArtifactWithMetadata(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, xRegistryVersion, artifactType, content, metaData, referencesAsDtos);
        return V2ApiUtil.dtoToVersionMetaData(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, artifactType, amd);
    }

    private void checkIfDeprecated(Supplier<ArtifactState> stateSupplier, String groupId, String artifactId, String version, Response.ResponseBuilder builder) {
        HeadersHack.checkIfDeprecated(stateSupplier, groupId, artifactId, version, builder);
    }

    private String lookupArtifactType(String groupId, String artifactId) {
        return this.storage.getArtifactMetaData(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId).getType();
    }

    private String getContentType() {
        return this.request.getContentType();
    }

    private static final void requireParameter(String parameterName, Object parameterValue) {
        if (parameterValue == null) {
            throw new MissingRequiredParameterException(parameterName);
        }
    }

    private static void maxOneOf(String parameterOneName, Object parameterOneValue, String parameterTwoName, Object parameterTwoValue) {
        if (parameterOneValue != null && parameterTwoValue != null) {
            throw new ParametersConflictException(parameterOneName, parameterTwoName);
        }
    }

    private static <T> T getOneOf(T parameterOneValue, T parameterTwoValue) {
        return parameterOneValue != null ? parameterOneValue : parameterTwoValue;
    }

    private static String decode(String encoded) {
        if (encoded == null) {
            return null;
        }
        return new String(Base64.decode((String)encoded));
    }

    private ArtifactMetaData handleIfExists(String groupId, String artifactId, String version, IfExists ifExists, String artifactName, String artifactDescription, ContentHandle content, String contentType, boolean canonical, List<ArtifactReference> references) {
        ArtifactMetaData artifactMetaData = this.getArtifactMetaData(groupId, artifactId);
        if (ifExists == null) {
            ifExists = IfExists.FAIL;
        }
        switch (ifExists) {
            case UPDATE: {
                return this.updateArtifactInternal(groupId, artifactId, version, artifactName, artifactDescription, content, contentType, references);
            }
            case RETURN: {
                return artifactMetaData;
            }
            case RETURN_OR_UPDATE: {
                return this.handleIfExistsReturnOrUpdate(groupId, artifactId, version, artifactName, artifactDescription, content, contentType, canonical, references);
            }
        }
        throw new ArtifactAlreadyExistsException(groupId, artifactId);
    }

    private ArtifactMetaData handleIfExistsReturnOrUpdate(String groupId, String artifactId, String version, String artifactName, String artifactDescription, ContentHandle content, String contentType, boolean canonical, List<ArtifactReference> references) {
        try {
            ArtifactVersionMetaDataDto mdDto = this.storage.getArtifactVersionMetaData(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, canonical, content, this.toReferenceDtos(references));
            ArtifactMetaData md = V2ApiUtil.dtoToMetaData(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, null, mdDto);
            return md;
        }
        catch (ArtifactNotFoundException artifactNotFoundException) {
            return this.updateArtifactInternal(groupId, artifactId, version, artifactName, artifactDescription, content, contentType, references);
        }
    }

    private ArtifactMetaData updateArtifactInternal(String groupId, String artifactId, String version, String name, String description, ContentHandle content, String contentType, List<ArtifactReference> references) {
        if (ContentTypeUtil.isApplicationYaml(contentType)) {
            content = ContentTypeUtil.yamlToJson(content);
        }
        String artifactType = this.lookupArtifactType(groupId, artifactId);
        List<ArtifactReferenceDto> referencesAsDtos = this.toReferenceDtos(references);
        Map<String, ContentHandle> resolvedReferences = this.storage.resolveReferences(referencesAsDtos);
        this.rulesService.applyRules(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, artifactType, content, RuleApplicationType.UPDATE, references, resolvedReferences);
        EditableArtifactMetaDataDto metaData = this.getEditableMetaData(name, description);
        ArtifactMetaDataDto dto = this.storage.updateArtifactWithMetadata(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, version, artifactType, content, metaData, referencesAsDtos);
        return V2ApiUtil.dtoToMetaData(V2ApiUtil.defaultGroupIdToNull(groupId), artifactId, artifactType, dto);
    }

    private EditableArtifactMetaDataDto getEditableMetaData(String name, String description) {
        if (name != null || description != null) {
            return new EditableArtifactMetaDataDto(name, description, null, null);
        }
        return null;
    }

    private List<ArtifactReferenceDto> toReferenceDtos(List<ArtifactReference> references) {
        if (references == null) {
            references = Collections.emptyList();
        }
        return references.stream().map(r -> {
            r.setGroupId(V2ApiUtil.defaultGroupIdToNull(r.getGroupId()));
            return r;
        }).map(V2ApiUtil::referenceToDto).collect(Collectors.toList());
    }

    public static enum RegistryHashAlgorithm {
        SHA256,
        MD5;

    }
}

