/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.v2;

import io.apicurio.common.apps.logging.Logged;
import io.apicurio.registry.auth.Authorized;
import io.apicurio.registry.auth.AuthorizedLevel;
import io.apicurio.registry.auth.AuthorizedStyle;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.metrics.health.liveness.ResponseErrorLivenessCheck;
import io.apicurio.registry.metrics.health.readiness.ResponseTimeoutReadinessCheck;
import io.apicurio.registry.rest.HeadersHack;
import io.apicurio.registry.rest.v2.IdsResource;
import io.apicurio.registry.rest.v2.V2ApiUtil;
import io.apicurio.registry.rest.v2.beans.ArtifactReference;
import io.apicurio.registry.rest.v2.shared.CommonResourceOperations;
import io.apicurio.registry.storage.ArtifactNotFoundException;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.dto.ArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.ContentWrapperDto;
import io.apicurio.registry.storage.dto.StoredArtifactDto;
import io.apicurio.registry.types.ArtifactMediaTypes;
import io.apicurio.registry.types.ArtifactState;
import io.apicurio.registry.types.Current;
import io.apicurio.registry.types.ReferenceType;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProviderFactory;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.interceptor.Interceptors;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;

@ApplicationScoped
@Interceptors(value={ResponseErrorLivenessCheck.class, ResponseTimeoutReadinessCheck.class})
@Logged
public class IdsResourceImpl
implements IdsResource {
    @Inject
    @Current
    RegistryStorage storage;
    @Inject
    ArtifactTypeUtilProviderFactory factory;
    @Inject
    CommonResourceOperations common;

    private void checkIfDeprecated(Supplier<ArtifactState> stateSupplier, String artifactId, String version, Response.ResponseBuilder builder) {
        HeadersHack.checkIfDeprecated(stateSupplier, null, artifactId, version, builder);
    }

    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Read)
    public Response getContentById(long contentId) {
        ContentHandle content = this.storage.getArtifactByContentId(contentId).getContent();
        Response.ResponseBuilder builder = Response.ok((Object)content, (MediaType)ArtifactMediaTypes.BINARY);
        return builder.build();
    }

    @Authorized(style=AuthorizedStyle.GlobalId, level=AuthorizedLevel.Read)
    public Response getContentByGlobalId(long globalId, Boolean dereference) {
        ArtifactMetaDataDto metaData = this.storage.getArtifactMetaData(globalId);
        if (ArtifactState.DISABLED.equals((Object)metaData.getState())) {
            throw new ArtifactNotFoundException(null, String.valueOf(globalId));
        }
        if (dereference == null) {
            dereference = Boolean.FALSE;
        }
        StoredArtifactDto artifact = this.storage.getArtifactVersion(globalId);
        MediaType contentType = this.factory.getArtifactMediaType(metaData.getType());
        ContentHandle contentToReturn = artifact.getContent();
        Response.ResponseBuilder builder = Response.ok((Object)contentToReturn, (MediaType)contentType);
        this.checkIfDeprecated(metaData::getState, metaData.getId(), metaData.getVersion(), builder);
        return builder.build();
    }

    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Read)
    public Response getContentByHash(String contentHash) {
        ContentHandle content = this.storage.getArtifactByContentHash(contentHash).getContent();
        Response.ResponseBuilder builder = Response.ok((Object)content, (MediaType)ArtifactMediaTypes.BINARY);
        return builder.build();
    }

    public List<ArtifactReference> referencesByContentHash(String contentHash) {
        return this.common.getReferencesByContentHash(contentHash);
    }

    public List<ArtifactReference> referencesByContentId(long contentId) {
        ContentWrapperDto artifact = this.storage.getArtifactByContentId(contentId);
        return artifact.getReferences().stream().map(V2ApiUtil::referenceDtoToReference).collect(Collectors.toList());
    }

    public List<ArtifactReference> referencesByGlobalId(long globalId, ReferenceType refType) {
        if (refType == ReferenceType.OUTBOUND || refType == null) {
            StoredArtifactDto artifact = this.storage.getArtifactVersion(globalId);
            return artifact.getReferences().stream().map(V2ApiUtil::referenceDtoToReference).collect(Collectors.toList());
        }
        ArtifactMetaDataDto amd = this.storage.getArtifactMetaData(globalId);
        return this.storage.getInboundArtifactReferences(amd.getGroupId(), amd.getId(), amd.getVersion()).stream().map(V2ApiUtil::referenceDtoToReference).collect(Collectors.toList());
    }
}

