/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.services;

import io.quarkus.runtime.configuration.ProfileManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class RegistryConfigSource
implements ConfigSource {
    private Map<String, String> properties;

    public synchronized Map<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
            String prefix = System.getenv("REGISTRY_PROPERTIES_PREFIX");
            if (prefix != null) {
                String profile = ProfileManager.getActiveProfile();
                String profilePrefix = "%" + profile + ".";
                Map<String, String> envMap = System.getenv();
                for (Map.Entry<String, String> entry : envMap.entrySet()) {
                    String key = entry.getKey();
                    if (!key.startsWith(prefix)) continue;
                    String newKey = profilePrefix + key.replace("_", ".").toLowerCase();
                    this.properties.put(newKey, entry.getValue());
                }
            }
        }
        return this.properties;
    }

    public Set<String> getPropertyNames() {
        return new HashSet<String>(this.properties.values());
    }

    public String getValue(String key) {
        return this.getProperties().get(key);
    }

    public String getName() {
        return "Registry properties";
    }
}

