/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.services.http;

import io.apicurio.common.apps.config.Info;
import io.apicurio.common.apps.multitenancy.exceptions.TenantForbiddenException;
import io.apicurio.common.apps.multitenancy.exceptions.TenantNotAuthorizedException;
import io.apicurio.common.apps.multitenancy.exceptions.TenantNotFoundException;
import io.apicurio.registry.ccompat.rest.error.ConflictException;
import io.apicurio.registry.ccompat.rest.error.UnprocessableEntityException;
import io.apicurio.registry.metrics.health.liveness.LivenessUtil;
import io.apicurio.registry.metrics.health.liveness.ResponseErrorLivenessCheck;
import io.apicurio.registry.mt.limits.LimitExceededException;
import io.apicurio.registry.rest.MissingRequiredParameterException;
import io.apicurio.registry.rest.ParametersConflictException;
import io.apicurio.registry.rest.v2.beans.Error;
import io.apicurio.registry.rest.v2.beans.RuleViolationCause;
import io.apicurio.registry.rest.v2.beans.RuleViolationError;
import io.apicurio.registry.rules.DefaultRuleDeletionException;
import io.apicurio.registry.rules.RuleViolation;
import io.apicurio.registry.rules.RuleViolationException;
import io.apicurio.registry.rules.UnprocessableSchemaException;
import io.apicurio.registry.services.http.ErrorHttpResponse;
import io.apicurio.registry.storage.AlreadyExistsException;
import io.apicurio.registry.storage.ArtifactAlreadyExistsException;
import io.apicurio.registry.storage.ArtifactNotFoundException;
import io.apicurio.registry.storage.ConfigPropertyNotFoundException;
import io.apicurio.registry.storage.ContentNotFoundException;
import io.apicurio.registry.storage.DownloadNotFoundException;
import io.apicurio.registry.storage.GroupNotFoundException;
import io.apicurio.registry.storage.InvalidArtifactIdException;
import io.apicurio.registry.storage.InvalidArtifactStateException;
import io.apicurio.registry.storage.InvalidArtifactTypeException;
import io.apicurio.registry.storage.InvalidGroupIdException;
import io.apicurio.registry.storage.InvalidPropertyValueException;
import io.apicurio.registry.storage.LogConfigurationNotFoundException;
import io.apicurio.registry.storage.NotFoundException;
import io.apicurio.registry.storage.RoleMappingAlreadyExistsException;
import io.apicurio.registry.storage.RoleMappingNotFoundException;
import io.apicurio.registry.storage.RuleAlreadyExistsException;
import io.apicurio.registry.storage.RuleNotFoundException;
import io.apicurio.registry.storage.VersionAlreadyExistsException;
import io.apicurio.registry.storage.VersionNotFoundException;
import io.apicurio.rest.client.auth.exception.ForbiddenException;
import io.apicurio.rest.client.auth.exception.NotAuthorizedException;
import io.apicurio.tenantmanager.client.exception.TenantManagerClientException;
import io.quarkus.security.UnauthorizedException;
import io.smallrye.mutiny.TimeoutException;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;

@ApplicationScoped
public class RegistryExceptionMapperService {
    private static final int HTTP_UNPROCESSABLE_ENTITY = 422;
    private static final Map<Class<? extends Exception>, Integer> CODE_MAP;
    @Inject
    Logger log;
    @Inject
    ResponseErrorLivenessCheck liveness;
    @Inject
    LivenessUtil livenessUtil;
    @ConfigProperty(name="registry.api.errors.include-stack-in-response", defaultValue="false")
    @Info(category="api", description="Include stack trace in errors responses", availableSince="2.1.4.Final")
    boolean includeStackTrace;

    public static Set<Class<? extends Exception>> getIgnored() {
        return CODE_MAP.keySet();
    }

    public ErrorHttpResponse mapException(Throwable t) {
        int code;
        Response response = null;
        if (t instanceof WebApplicationException) {
            WebApplicationException wae = (WebApplicationException)t;
            response = wae.getResponse();
            code = response.getStatus();
        } else {
            code = CODE_MAP.getOrDefault(t.getClass(), 500);
        }
        if (code == 500) {
            if (!this.livenessUtil.isIgnoreError(t)) {
                this.liveness.suspectWithException(t);
            }
            this.log.error("[500 ERROR DETECTED] : " + t.getMessage(), t);
        }
        Error error = this.toError(t, code);
        return new ErrorHttpResponse(code, error, response);
    }

    private Error toError(Throwable t, int code) {
        Error error;
        if (t instanceof RuleViolationException) {
            RuleViolationException rve = (RuleViolationException)t;
            error = new RuleViolationError();
            ((RuleViolationError)error).setCauses(this.toRestCauses(rve.getCauses()));
        } else {
            error = new Error();
        }
        error.setErrorCode(Integer.valueOf(code));
        error.setMessage(t.getLocalizedMessage());
        if (this.includeStackTrace) {
            error.setDetail(RegistryExceptionMapperService.getStackTrace(t));
        } else {
            error.setDetail(RegistryExceptionMapperService.getRootMessage(t));
        }
        error.setName(t.getClass().getSimpleName());
        return error;
    }

    private List<RuleViolationCause> toRestCauses(Set<RuleViolation> violations) {
        if (violations == null) {
            return null;
        }
        return violations.stream().map(violation -> {
            RuleViolationCause cause = new RuleViolationCause();
            cause.setContext(violation.getContext());
            cause.setDescription(violation.getDescription());
            return cause;
        }).collect(Collectors.toList());
    }

    private static String getStackTrace(Throwable t) {
        String string;
        StringWriter writer = new StringWriter();
        try {
            t.printStackTrace(new PrintWriter(writer));
            string = writer.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return null;
            }
        }
        writer.close();
        return string;
    }

    private static String getRootMessage(Throwable t) {
        return ExceptionUtils.getRootCauseMessage((Throwable)t);
    }

    static {
        HashMap<Class<TimeoutException>, Integer> map = new HashMap<Class<TimeoutException>, Integer>();
        map.put(AlreadyExistsException.class, 409);
        map.put(ArtifactAlreadyExistsException.class, 409);
        map.put(VersionAlreadyExistsException.class, 409);
        map.put(ArtifactNotFoundException.class, 404);
        map.put(ContentNotFoundException.class, 404);
        map.put(BadRequestException.class, 400);
        map.put(InvalidArtifactStateException.class, 400);
        map.put(NotFoundException.class, 404);
        map.put(RuleAlreadyExistsException.class, 409);
        map.put(RuleNotFoundException.class, 404);
        map.put(RuleViolationException.class, 409);
        map.put(DefaultRuleDeletionException.class, 409);
        map.put(VersionNotFoundException.class, 404);
        map.put(ConflictException.class, 409);
        map.put(UnprocessableEntityException.class, 422);
        map.put(UnprocessableSchemaException.class, 422);
        map.put(InvalidArtifactTypeException.class, 400);
        map.put(InvalidArtifactIdException.class, 400);
        map.put(InvalidPropertyValueException.class, 400);
        map.put(InvalidGroupIdException.class, 400);
        map.put(MissingRequiredParameterException.class, 400);
        map.put(LogConfigurationNotFoundException.class, 404);
        map.put(GroupNotFoundException.class, 404);
        map.put(LimitExceededException.class, 409);
        map.put(TenantNotAuthorizedException.class, 403);
        map.put(TenantForbiddenException.class, 403);
        map.put(RoleMappingAlreadyExistsException.class, 409);
        map.put(RoleMappingNotFoundException.class, 404);
        map.put(TenantManagerClientException.class, 500);
        map.put(io.apicurio.registry.rest.ConflictException.class, 409);
        map.put(ParametersConflictException.class, 409);
        map.put(DownloadNotFoundException.class, 404);
        map.put(ConfigPropertyNotFoundException.class, 404);
        map.put(UnauthorizedException.class, 401);
        map.put(io.quarkus.security.ForbiddenException.class, 403);
        map.put(NotAuthorizedException.class, 403);
        map.put(ForbiddenException.class, 403);
        map.put(TenantNotFoundException.class, 403);
        map.put(TimeoutException.class, 503);
        CODE_MAP = Collections.unmodifiableMap(map);
    }
}

