/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage;

import io.apicurio.registry.storage.NotFoundException;

public class ArtifactNotFoundException
extends NotFoundException {
    private static final long serialVersionUID = -3614783501078800654L;
    private String groupId;
    private String artifactId;

    public ArtifactNotFoundException(String groupId, String artifactId) {
        this.groupId = groupId;
        this.artifactId = artifactId;
    }

    public ArtifactNotFoundException(String groupId, String artifactId, Throwable cause) {
        super("Artifact with ID '" + artifactId + "' in group '" + groupId + "'  not found.", cause);
        this.groupId = groupId;
        this.artifactId = artifactId;
    }

    public ArtifactNotFoundException(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getMessage() {
        return "No artifact with ID '" + this.artifactId + "' in group '" + this.groupId + "' was found.";
    }
}

