/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage;

import io.apicurio.registry.storage.InvalidArtifactStateException;
import io.apicurio.registry.types.ArtifactState;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;

@ApplicationScoped
public class ArtifactStateExt {
    private static final Map<ArtifactState, EnumSet<ArtifactState>> transitions = new HashMap<ArtifactState, EnumSet<ArtifactState>>();
    public static final EnumSet<ArtifactState> ACTIVE_STATES;
    @Inject
    Logger log;

    public boolean canTransition(ArtifactState before, ArtifactState after) {
        EnumSet<ArtifactState> states = transitions.get(before);
        return states.contains(after);
    }

    public void validateState(EnumSet<ArtifactState> states, ArtifactState state, String groupId, String artifactId, String version) {
        if (states != null && !states.contains(state)) {
            throw new InvalidArtifactStateException(groupId, artifactId, version, state);
        }
        this.logIfDeprecated(groupId, artifactId, version, state);
    }

    public void logIfDeprecated(String groupId, Object artifactId, Object version, ArtifactState state) {
        if (state == ArtifactState.DEPRECATED) {
            this.log.warn("Artifact {} [{}] in group ({}) is deprecated", new Object[]{artifactId, version, groupId});
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void applyState(Consumer<ArtifactState> consumer, ArtifactState previousState, ArtifactState newState) {
        if (previousState == newState) return;
        if (previousState != null) {
            if (!this.canTransition(previousState, newState)) throw new InvalidArtifactStateException(previousState, newState);
            consumer.accept(newState);
            return;
        } else {
            consumer.accept(newState);
        }
    }

    static {
        transitions.put(ArtifactState.ENABLED, EnumSet.of(ArtifactState.DISABLED, ArtifactState.DEPRECATED));
        transitions.put(ArtifactState.DISABLED, EnumSet.of(ArtifactState.ENABLED, ArtifactState.DEPRECATED));
        transitions.put(ArtifactState.DEPRECATED, EnumSet.of(ArtifactState.ENABLED, ArtifactState.DISABLED));
        ACTIVE_STATES = EnumSet.of(ArtifactState.ENABLED, ArtifactState.DEPRECATED, ArtifactState.DISABLED);
    }
}

