/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.sql;

import io.apicurio.registry.storage.impl.sql.DdlParser;
import io.apicurio.registry.storage.impl.sql.SqlStatements;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public abstract class CommonSqlStatements
implements SqlStatements {
    @Override
    public List<String> databaseInitialization() {
        List<String> list;
        block9: {
            DdlParser parser = new DdlParser();
            InputStream input = this.getClass().getResourceAsStream(this.dbType() + ".ddl");
            try {
                if (input == null) {
                    throw new RuntimeException("DDL not found for dbtype: " + this.dbType());
                }
                list = parser.parse(input);
                if (input == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            input.close();
        }
        return list;
    }

    @Override
    public List<String> databaseUpgrade(int fromVersion, int toVersion) {
        ArrayList<String> statements = new ArrayList<String>();
        DdlParser parser = new DdlParser();
        for (int version = fromVersion + 1; version <= toVersion; ++version) {
            try (InputStream input = this.getClass().getResourceAsStream("upgrades/" + version + "/" + this.dbType() + ".upgrade.ddl");){
                statements.addAll(parser.parse(input));
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return statements;
    }

    @Override
    public String getDatabaseVersion() {
        return "SELECT a.prop_value FROM apicurio a WHERE a.prop_name = ?";
    }

    @Override
    public String insertGlobalRule() {
        return "INSERT INTO globalrules (tenantId, type, configuration) VALUES (?, ?, ?)";
    }

    @Override
    public String selectGlobalRules() {
        return "SELECT r.type FROM globalrules r WHERE r.tenantId = ?";
    }

    @Override
    public String selectGlobalRuleByType() {
        return "SELECT r.* FROM globalrules r WHERE r.tenantId = ? AND r.type = ?";
    }

    @Override
    public String deleteGlobalRule() {
        return "DELETE FROM globalrules WHERE tenantId = ? AND type = ?";
    }

    @Override
    public String deleteGlobalRules() {
        return "DELETE FROM globalrules WHERE tenantId = ?";
    }

    @Override
    public String updateGlobalRule() {
        return "UPDATE globalrules SET configuration = ? WHERE tenantId = ? AND type = ?";
    }

    @Override
    public String insertArtifact() {
        return "INSERT INTO artifacts (tenantId, groupId, artifactId, type, createdBy, createdOn) VALUES (?, ?, ?, ?, ?, ?)";
    }

    @Override
    public String updateArtifactLatest() {
        return "UPDATE artifacts SET latest = ? WHERE tenantId = ? AND groupId = ? AND artifactId = ?";
    }

    @Override
    public String updateArtifactLatestGlobalId() {
        return "UPDATE artifacts SET latest = (SELECT v.globalId FROM versions v WHERE v.tenantId = ? AND v.groupId = ? AND v.artifactId = ? AND v.version = ?) WHERE tenantId = ? AND groupId = ? AND artifactId = ?";
    }

    @Override
    public String autoUpdateVersionForGlobalId() {
        return "UPDATE versions SET version = (SELECT versionId FROM versions WHERE tenantId = ? AND globalId = ?) WHERE tenantId = ? AND globalId = ?";
    }

    @Override
    public String insertVersion(boolean firstVersion) {
        String query = firstVersion ? "INSERT INTO versions (globalId, tenantId, groupId, artifactId, version, versionId, state, name, description, createdBy, createdOn, labels, properties, contentId) VALUES (?, ?, ?, ?, ?, 1, ?, ?, ?, ?, ?, ?, ?, ?)" : "INSERT INTO versions (globalId, tenantId, groupId, artifactId, version, versionId, state, name, description, createdBy, createdOn, labels, properties, contentId) VALUES (?, ?, ?, ?, ?, (SELECT MAX(versionId) + 1 FROM versions WHERE tenantId = ? AND groupId = ? AND artifactId = ?), ?, ?, ?, ?, ?, ?, ?, ?)";
        return query;
    }

    @Override
    public String selectArtifactVersionMetaDataByGlobalId() {
        return "SELECT v.*, a.type FROM versions v JOIN artifacts a ON v.tenantId = a.tenantId AND v.groupId = a.groupId AND v.artifactId = a.artifactId WHERE v.tenantId = ? AND v.globalId = ?";
    }

    @Override
    public String selectArtifactVersions() {
        return "SELECT version FROM versions WHERE tenantId = ? AND groupId = ? AND artifactId = ?";
    }

    @Override
    public String selectArtifactVersionMetaData() {
        return "SELECT v.*, a.type FROM versions v JOIN artifacts a ON v.tenantId = a.tenantId AND v.groupId = a.groupId AND v.artifactId = a.artifactId WHERE v.tenantId = ? AND v.groupId = ? AND v.artifactId = ? AND v.version = ?";
    }

    @Override
    public String selectArtifactVersionMetaDataByContentHash() {
        return "SELECT v.*, a.type FROM versions v JOIN content c ON v.contentId = c.contentId AND v.tenantId = c.tenantId JOIN artifacts a ON v.tenantId = a.tenantId AND v.groupId = a.groupId AND v.artifactId = a.artifactId WHERE v.tenantId = ? AND v.groupId = ? AND v.artifactId = ? AND c.contentHash = ? ORDER BY v.globalId DESC";
    }

    @Override
    public String selectArtifactVersionMetaDataByContentId() {
        return "SELECT a.*, v.contentId, v.globalId, v.version, v.versionId, v.state, v.name, v.description, v.labels, v.properties, v.createdBy AS modifiedBy, v.createdOn AS modifiedOn FROM versions v JOIN artifacts a ON v.tenantId = a.tenantId AND v.groupId = a.groupId AND v.artifactId = a.artifactId WHERE v.tenantId = ? AND v.contentId = ?";
    }

    @Override
    public String selectArtifactVersionMetaDataByCanonicalHash() {
        return "SELECT v.*, a.type FROM versions v JOIN content c ON v.contentId = c.contentId AND v.tenantId = c.tenantId JOIN artifacts a ON v.tenantId = a.tenantId AND v.groupId = a.groupId AND v.artifactId = a.artifactId WHERE v.tenantId = ? AND v.groupId = ? AND v.artifactId = ? AND c.canonicalHash = ? ORDER BY v.globalId DESC";
    }

    @Override
    public String selectArtifactVersionContentByGlobalId() {
        return "SELECT v.globalId, v.version, v.versionId, v.contentId, c.content, c.artifactreferences FROM versions v JOIN content c ON v.contentId = c.contentId AND v.tenantId = c.tenantId WHERE v.tenantId = ? AND v.globalId = ?";
    }

    @Override
    public String selectArtifactVersionContent() {
        return "SELECT v.globalId, v.version, v.versionId, c.contentId, c.content, c.artifactreferences FROM versions v JOIN content c ON v.contentId = c.contentId AND v.tenantId = c.tenantId WHERE v.tenantId = ? AND v.groupId = ? AND v.artifactId = ? AND v.version = ?";
    }

    @Override
    public String selectArtifactContentIds() {
        return "SELECT v.contentId FROM versions v WHERE v.tenantId = ? AND v.groupId = ? AND v.artifactId = ? ORDER BY v.versionId";
    }

    @Override
    public String selectLatestArtifactContent() {
        return "SELECT v.globalId, v.version, v.versionId, c.contentId, c.content, c.artifactreferences FROM artifacts a JOIN versions v ON a.tenantId = v.tenantId AND a.latest = v.globalId JOIN content c ON v.contentId = c.contentId AND v.tenantId = c.tenantId WHERE a.tenantId = ? AND a.groupId = ? AND a.artifactId = ?";
    }

    @Override
    public String selectLatestArtifactContentSkipDisabledState() {
        return "SELECT v.globalId, v.version, v.versionId, c.contentId, c.content, c.artifactreferences FROM artifacts a JOIN versions v ON a.tenantId = v.tenantId AND a.latest = v.globalId JOIN content c ON v.contentId = c.contentId AND v.tenantId = c.tenantId WHERE a.tenantId = ? AND a.groupId = ? AND a.artifactId = ? AND v.state != 'DISABLED'";
    }

    @Override
    public String selectLatestArtifactContentWithMaxGlobalIDSkipDisabledState() {
        String inner = "SELECT MAX(v.globalId) FROM versions v WHERE v.tenantId = ? AND v.groupId = ? AND v.artifactId = ? AND v.state != 'DISABLED'";
        return "SELECT v.globalId, v.version, v.versionId, c.contentId, c.content, c.artifactreferences FROM artifacts a JOIN versions v ON a.tenantId = v.tenantId AND a.groupId = v.groupId AND a.artifactId = v.artifactId JOIN content c ON v.contentId = c.contentId AND v.tenantId = c.tenantId WHERE a.tenantId = ? AND a.groupId = ? AND a.artifactId = ? AND v.globalId IN (" + inner + ")";
    }

    @Override
    public String selectLatestArtifactMetaData() {
        return "SELECT a.*, v.contentId, v.globalId, v.version, v.versionId, v.state, v.name, v.description, v.labels, v.properties, v.createdBy AS modifiedBy, v.createdOn AS modifiedOn FROM artifacts a JOIN versions v ON a.tenantId = v.tenantId AND a.latest = v.globalId WHERE a.tenantId = ? AND a.groupId = ? AND a.artifactId = ?";
    }

    @Override
    public String selectLatestArtifactMetaDataSkipDisabledState() {
        return "SELECT a.*, v.contentId, v.globalId, v.version, v.versionId, v.state, v.name, v.description, v.labels, v.properties, v.createdBy AS modifiedBy, v.createdOn AS modifiedOn FROM artifacts a JOIN versions v ON a.tenantId = v.tenantId AND a.latest = v.globalId WHERE a.tenantId = ? AND a.groupId = ? AND a.artifactId = ? AND v.state != 'DISABLED'";
    }

    @Override
    public String selectLatestArtifactMetaDataWithMaxGlobalIDSkipDisabledState() {
        String inner = "SELECT MAX(v.globalId) FROM versions v WHERE v.tenantId = ? AND v.groupId = ? AND v.artifactId = ? AND v.state != 'DISABLED'";
        return "SELECT a.*, v.contentId, v.globalId, v.version, v.versionId, v.state, v.name, v.description, v.labels, v.properties, v.createdBy AS modifiedBy, v.createdOn AS modifiedOn FROM artifacts a JOIN versions v ON a.tenantId = v.tenantId AND a.groupId = v.groupId AND a.artifactId = v.artifactId WHERE a.tenantId = ? AND a.groupId = ? AND a.artifactId = ? AND v.globalId IN (" + inner + ")";
    }

    @Override
    public String selectContentIdByHash() {
        return "SELECT c.contentId FROM content c WHERE c.contentHash = ? AND c.tenantId = ?";
    }

    @Override
    public String selectArtifactRules() {
        return "SELECT r.* FROM rules r WHERE r.tenantId = ? AND r.groupId = ? AND r.artifactId = ?";
    }

    @Override
    public String insertArtifactRule() {
        return "INSERT INTO rules (tenantId, groupId, artifactId, type, configuration) VALUES (?, ?, ?, ?, ?)";
    }

    @Override
    public String selectArtifactRuleByType() {
        return "SELECT r.* FROM rules r WHERE r.tenantId = ? AND r.groupId = ? AND r.artifactId = ? AND r.type = ?";
    }

    @Override
    public String updateArtifactRule() {
        return "UPDATE rules SET configuration = ? WHERE tenantId = ? AND groupId = ? AND artifactId = ? AND type = ?";
    }

    @Override
    public String updateArtifactOwner() {
        return "UPDATE artifacts SET createdBy = ? WHERE tenantId = ? AND groupId = ? AND artifactId = ?";
    }

    @Override
    public String deleteArtifactRule() {
        return "DELETE FROM rules WHERE tenantId = ? AND groupId = ? AND artifactId = ? AND type = ?";
    }

    @Override
    public String deleteArtifactRules() {
        return "DELETE FROM rules WHERE tenantId = ? AND groupId = ? AND artifactId = ?";
    }

    @Override
    public String deleteAllArtifactRules() {
        return "DELETE FROM rules WHERE tenantId = ?";
    }

    @Override
    public String deleteArtifactRulesByGroupId() {
        return "DELETE FROM rules WHERE tenantId = ? AND groupId = ?";
    }

    @Override
    public String updateArtifactVersionMetaData() {
        return "UPDATE versions SET name = ?, description = ?, labels = ?, properties = ? WHERE tenantId = ? AND groupId = ? AND artifactId = ? AND version = ?";
    }

    @Override
    public String deleteLabels() {
        return "DELETE FROM labels WHERE tenantId = ? AND globalId IN (SELECT globalId FROM versions WHERE tenantId = ? AND groupId = ? AND artifactId = ?)";
    }

    @Override
    public String deleteLabelsByGlobalId() {
        return "DELETE FROM labels WHERE tenantId = ? AND globalId = ?";
    }

    @Override
    public String deleteLabelsByGroupId() {
        return "DELETE FROM labels WHERE tenantId = ? AND globalId IN (SELECT globalId FROM versions WHERE tenantId = ? AND groupId = ?)";
    }

    @Override
    public String deleteAllLabels() {
        return "DELETE FROM labels WHERE tenantId = ? AND globalId IN (SELECT globalId FROM versions WHERE tenantId = ?)";
    }

    @Override
    public String deleteProperties() {
        return "DELETE FROM properties WHERE tenantId = ? AND globalId IN (SELECT globalId FROM versions WHERE tenantId = ? AND groupId = ? AND artifactId = ?)";
    }

    @Override
    public String deletePropertiesByGlobalId() {
        return "DELETE FROM properties WHERE tenantId = ? AND globalId = ?";
    }

    @Override
    public String deletePropertiesByGroupId() {
        return "DELETE FROM properties WHERE tenantId = ? AND globalId IN (SELECT globalId FROM versions WHERE tenantId = ? AND groupId = ?)";
    }

    @Override
    public String deleteAllProperties() {
        return "DELETE FROM properties WHERE tenantId = ? AND globalId IN (SELECT globalId FROM versions WHERE tenantId = ?)";
    }

    @Override
    public String deleteAllComments() {
        return "DELETE FROM comments WHERE tenantId = ? AND globalId IN (SELECT globalId FROM versions WHERE tenantId = ?)";
    }

    @Override
    public String deleteVersions() {
        return "DELETE FROM versions WHERE tenantId = ? AND groupId = ? AND artifactId = ?";
    }

    @Override
    public String deleteVersionsByGroupId() {
        return "DELETE FROM versions WHERE tenantId = ? AND groupId = ?";
    }

    @Override
    public String deleteAllVersions() {
        return "DELETE FROM versions WHERE tenantId = ?";
    }

    @Override
    public String deleteArtifact() {
        return "DELETE FROM artifacts WHERE tenantId = ? AND groupId = ? AND artifactId = ?";
    }

    @Override
    public String deleteArtifactsByGroupId() {
        return "DELETE FROM artifacts WHERE tenantId = ? AND groupId = ?";
    }

    @Override
    public String deleteAllArtifacts() {
        return "DELETE FROM artifacts WHERE tenantId = ?";
    }

    @Override
    public String selectArtifactIds() {
        return "SELECT artifactId FROM artifacts WHERE tenantId = ? LIMIT ?";
    }

    @Override
    public String selectArtifactMetaDataByGlobalId() {
        return "SELECT a.*, v.contentId, v.globalId, v.version, v.versionId, v.state, v.name, v.description, v.labels, v.properties, v.createdBy AS modifiedBy, v.createdOn AS modifiedOn FROM artifacts a JOIN versions v ON a.tenantId = v.tenantId AND a.groupId = v.groupId AND a.artifactId = v.artifactId WHERE v.tenantId = ? AND v.globalId = ?";
    }

    @Override
    public String updateArtifactVersionState() {
        return "UPDATE versions SET state = ? WHERE tenantId = ? AND globalId = ?";
    }

    @Override
    public String deleteVersion() {
        return "DELETE FROM versions WHERE tenantId = ? AND groupId = ? AND artifactId = ? AND version = ?";
    }

    @Override
    public String deleteVersionLabels() {
        return "DELETE FROM labels WHERE tenantId = ? AND globalId IN (SELECT v.globalId FROM versions v WHERE v.tenantId = ? AND v.groupId = ? AND v.artifactId = ? AND v.version = ?)";
    }

    @Override
    public String deleteVersionProperties() {
        return "DELETE FROM properties WHERE tenantId = ? AND globalId IN (SELECT v.globalId FROM versions v WHERE v.tenantId = ? AND v.groupId = ? AND v.artifactId = ? AND v.version = ?)";
    }

    @Override
    public String deleteVersionComments() {
        return "DELETE FROM comments WHERE tenantId = ? AND globalId IN (SELECT v.globalId FROM versions v WHERE v.tenantId = ? AND v.groupId = ? AND v.artifactId = ? AND v.version = ?)";
    }

    @Override
    public String insertLabel() {
        return "INSERT INTO labels (tenantId, globalId, label) VALUES (?, ?, ?)";
    }

    @Override
    public String insertProperty() {
        return "INSERT INTO properties (tenantId, globalId, pkey, pvalue) VALUES (?, ?, ?, ?)";
    }

    @Override
    public String selectAllArtifactVersions() {
        return "SELECT v.*, a.type FROM versions v JOIN artifacts a ON a.tenantId = v.tenantId AND a.groupId = v.groupId AND a.artifactId = v.artifactId WHERE a.tenantId = ? AND a.groupId = ? AND a.artifactId = ? ORDER BY v.globalId ASC LIMIT ? OFFSET ?";
    }

    @Override
    public String selectAllArtifactCount() {
        return "SELECT COUNT(a.artifactId) FROM artifacts a WHERE a.tenantId = ? ";
    }

    @Override
    public String selectAllArtifactVersionsCount() {
        return "SELECT COUNT(v.globalId) FROM versions v JOIN artifacts a ON a.tenantId = v.tenantId AND a.groupId = v.groupId AND a.artifactId = v.artifactId WHERE a.tenantId = ? AND a.groupId = ? AND a.artifactId = ? ";
    }

    @Override
    public String selectTotalArtifactVersionsCount() {
        return "SELECT COUNT(v.globalId) FROM versions v JOIN artifacts a ON a.tenantId = v.tenantId AND a.groupId = v.groupId AND a.artifactId = v.artifactId WHERE a.tenantId = ?";
    }

    @Override
    public String selectArtifactCountById() {
        return "SELECT COUNT(a.artifactId) FROM artifacts a WHERE a.tenantId = ? AND a.groupId = ? AND a.artifactId = ?";
    }

    @Override
    public String selectGroupCountById() {
        return "SELECT COUNT(g.groupId) FROM groups g WHERE g.tenantId = ? AND g.groupId = ?";
    }

    @Override
    public String selectArtifactRuleCountByType() {
        return "SELECT COUNT(r.type) FROM rules r WHERE r.tenantId = ? AND r.groupId = ? AND r.artifactId = ? AND r.type = ?";
    }

    @Override
    public String selectGlobalRuleCountByType() {
        return "SELECT COUNT(r.type) FROM globalrules r WHERE r.tenantId = ? AND r.type = ?";
    }

    @Override
    public String selectContentCountByHash() {
        return "SELECT COUNT(c.contentId) FROM content c WHERE c.contentHash = ? AND c.tenantId = ?";
    }

    @Override
    public String selectContentById() {
        return "SELECT c.content, c.artifactreferences FROM content c WHERE c.tenantId = ? AND c.contentId = ?";
    }

    @Override
    public String selectContentByContentHash() {
        return "SELECT c.content, c.artifactreferences FROM content c WHERE c.tenantId = ? AND c.contentHash = ?";
    }

    @Override
    public String deleteAllOrphanedContent() {
        return "DELETE FROM content WHERE NOT EXISTS (SELECT 1 FROM versions v WHERE v.contentId = contentId AND v.tenantId = tenantId)";
    }

    @Override
    public String deleteAllContent() {
        return "DELETE FROM content WHERE tenantId = ?";
    }

    @Override
    public String updateContentCanonicalHash() {
        return "UPDATE content SET canonicalHash = ? WHERE tenantId = ? AND contentId = ? AND contentHash = ?";
    }

    @Override
    public String selectLogConfigurationByLogger() {
        return "SELECT l.logger, l.loglevel FROM logconfiguration l WHERE l.logger = ?";
    }

    @Override
    public String deleteLogConfiguration() {
        return "DELETE FROM logconfiguration WHERE logger = ?";
    }

    @Override
    public String selectAllLogConfigurations() {
        return "SELECT l.logger, l.loglevel FROM logconfiguration l";
    }

    @Override
    public String insertGroup() {
        return "INSERT INTO groups (tenantId, groupId, description, artifactsType, createdBy, createdOn, modifiedBy, modifiedOn, properties) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
    }

    @Override
    public String updateGroup() {
        return "UPDATE groups SET description = ? , artifactsType = ? , modifiedBy = ? , modifiedOn = ? , properties = ? WHERE tenantId = ? AND groupId = ?";
    }

    @Override
    public String deleteGroup() {
        return "DELETE FROM groups WHERE tenantId = ? AND groupId = ?";
    }

    @Override
    public String deleteAllGroups() {
        return "DELETE FROM groups WHERE tenantId = ?";
    }

    @Override
    public String selectGroups() {
        return "SELECT g.* FROM groups g WHERE g.tenantId = ?ORDER BY g.groupId ASC LIMIT ?";
    }

    @Override
    public String selectGroupByGroupId() {
        return "SELECT g.* FROM groups g WHERE g.tenantId = ? AND g.groupId = ?";
    }

    @Override
    public String exportArtifactRules() {
        return "SELECT * FROM rules r WHERE r.tenantId = ?";
    }

    @Override
    public String exportArtifactVersions() {
        return "SELECT v.*, a.type, a.latest FROM versions v JOIN artifacts a ON v.tenantId = a.tenantId AND v.groupId = a.groupId AND v.artifactId = a.artifactId WHERE v.tenantId = ?";
    }

    @Override
    public String exportComments() {
        return "SELECT * FROM comments c WHERE c.tenantId = ?";
    }

    @Override
    public String exportContent() {
        return "SELECT c.contentId, c.canonicalHash, c.contentHash, c.content, c.artifactreferences FROM content c WHERE c.tenantId = ?";
    }

    @Override
    public String exportGlobalRules() {
        return "SELECT * FROM globalrules r WHERE r.tenantId = ?";
    }

    @Override
    public String exportGroups() {
        return "SELECT * FROM groups g WHERE g.tenantId = ?";
    }

    @Override
    public String importArtifactRule() {
        return "INSERT INTO rules (tenantId, groupId, artifactId, type, configuration) VALUES (?, ?, ?, ?, ?)";
    }

    @Override
    public String importArtifactVersion() {
        return "INSERT INTO versions (globalId, tenantId, groupId, artifactId, version, versionId, state, name, description, createdBy, createdOn, labels, properties, contentId) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    }

    @Override
    public String importContent() {
        return "INSERT INTO content (tenantId, contentId, canonicalHash, contentHash, content, artifactreferences) VALUES (?, ?, ?, ?, ?, ?)";
    }

    @Override
    public String importGlobalRule() {
        return "INSERT INTO globalrules (tenantId, type, configuration) VALUES (?, ?, ?)";
    }

    @Override
    public String importGroup() {
        return "INSERT INTO groups (tenantId, groupId, description, artifactsType, createdBy, createdOn, modifiedBy, modifiedOn, properties) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
    }

    @Override
    public String selectMaxContentId() {
        return "SELECT MAX(contentId) FROM content WHERE tenantId = ?";
    }

    @Override
    public String selectMaxGlobalId() {
        return "SELECT MAX(globalId) FROM versions WHERE tenantId = ?";
    }

    @Override
    public String selectMaxCommentId() {
        return "SELECT MAX(commentId) FROM comments WHERE tenantId = ?";
    }

    @Override
    public String selectContentExists() {
        return "SELECT COUNT(contentId) FROM content WHERE contentId = ? AND tenantId = ?";
    }

    @Override
    public String selectGlobalIdExists() {
        return "SELECT COUNT(globalId) FROM versions WHERE globalId = ? AND tenantId = ?";
    }

    @Override
    public String insertRoleMapping() {
        return "INSERT INTO acls (tenantId, principalId, role, principalName) VALUES (?, ?, ?, ?)";
    }

    @Override
    public String deleteRoleMapping() {
        return "DELETE FROM acls WHERE tenantId = ? AND principalId = ?";
    }

    @Override
    public String deleteAllRoleMappings() {
        return "DELETE FROM acls WHERE tenantId = ?";
    }

    @Override
    public String selectRoleMappingByPrincipalId() {
        return "SELECT a.* FROM acls a WHERE a.tenantId = ? AND a.principalId = ?";
    }

    @Override
    public String selectRoleByPrincipalId() {
        return "SELECT a.role FROM acls a WHERE a.tenantId = ? AND a.principalId = ?";
    }

    @Override
    public String selectRoleMappings() {
        return "SELECT a.* FROM acls a WHERE a.tenantId = ?";
    }

    @Override
    public String updateRoleMapping() {
        return "UPDATE acls SET role = ? WHERE tenantId = ? AND principalId = ?";
    }

    @Override
    public String selectRoleMappingCountByPrincipal() {
        return "SELECT COUNT(a.principalId) FROM acls a WHERE a.tenantId = ? AND a.principalId = ?";
    }

    @Override
    public String insertDownload() {
        return "INSERT INTO downloads (tenantId, downloadId, expires, context) VALUES (?, ?, ?, ?)";
    }

    @Override
    public String selectDownloadContext() {
        return "SELECT d.context FROM downloads d WHERE d.tenantId = ? AND d.downloadId = ? AND expires > ?";
    }

    @Override
    public String deleteDownload() {
        return "DELETE FROM downloads WHERE tenantId = ? AND downloadId = ?";
    }

    @Override
    public String deleteExpiredDownloads() {
        return "DELETE FROM downloads WHERE expires < ?";
    }

    @Override
    public String selectConfigProperties() {
        return "SELECT c.* FROM config c WHERE c.tenantId = ?";
    }

    @Override
    public String selectConfigPropertyByName() {
        return "SELECT c.* FROM config c WHERE c.tenantId = ? AND c.pname = ?";
    }

    @Override
    public String deleteConfigProperty() {
        return "DELETE FROM config WHERE tenantId = ? AND pname = ?";
    }

    @Override
    public String insertConfigProperty() {
        return "INSERT INTO config (tenantId, pname, pvalue, modifiedOn) VALUES (?, ?, ?, ?)";
    }

    @Override
    public String deleteAllConfigProperties() {
        return "DELETE FROM config WHERE tenantId = ?";
    }

    @Override
    public String selectTenantIdsByConfigModifiedOn() {
        return "SELECT DISTINCT c.tenantId FROM config c WHERE c.modifiedOn >= ?";
    }

    @Override
    public String deleteAllReferences() {
        return "DELETE FROM artifactreferences WHERE tenantId = ?";
    }

    @Override
    public String deleteOrphanedReferences() {
        return "DELETE FROM artifactreferences WHERE NOT EXISTS (SELECT 1 FROM versions v WHERE v.contentId = contentId AND v.tenantId = tenantId)";
    }

    @Override
    public String selectContentIdsReferencingArtifactBy() {
        return "SELECT contentId FROM artifactreferences WHERE tenantId=? AND groupId=? AND artifactId=? AND version=?";
    }

    @Override
    public String selectGlobalIdsReferencingArtifactBy() {
        return "SELECT DISTINCT v.globalId FROM versions v JOIN artifactreferences ar ON v.tenantId=ar.tenantId AND v.contentId=ar.contentId WHERE ar.tenantId=? AND ar.groupId=? AND ar.artifactId=? AND ar.version=?";
    }

    @Override
    public String selectInboundReferencesByGAV() {
        return "SELECT DISTINCT v.groupId, v.artifactId, v.version, ar.name as name FROM versions v JOIN artifactreferences ar ON v.tenantId=ar.tenantId AND v.contentId=ar.contentId WHERE ar.tenantId=? AND ar.groupId=? AND ar.artifactId=? AND ar.version=?";
    }

    @Override
    public String insertSequenceValue() {
        return "INSERT INTO sequences (tenantId, name, value) VALUES (?, ?, ?)";
    }

    @Override
    public String selectCurrentSequenceValue() {
        return "SELECT value FROM sequences WHERE name = ? AND tenantId = ? ";
    }

    @Override
    public String insertComment() {
        return "INSERT INTO comments (tenantId, commentId, globalId, createdBy, createdOn, cvalue) VALUES (?, ?, ?, ?, ?, ?)";
    }

    @Override
    public String selectComments() {
        return "SELECT c.* FROM comments c JOIN versions v ON v.tenantId = c.tenantId AND v.globalId = c.globalId WHERE v.tenantId = ? AND v.groupId = ? AND v.artifactId = ? AND v.version = ? ORDER BY c.createdOn DESC";
    }

    @Override
    public String deleteComment() {
        return "DELETE FROM comments WHERE tenantId = ? AND globalId = ? AND commentId = ? AND createdBy = ?";
    }

    @Override
    public String updateComment() {
        return "UPDATE comments SET cvalue = ? WHERE tenantId = ? AND globalId = ? AND commentId = ? AND createdBy = ?";
    }
}

