/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.sql;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;

public class DdlParser {
    public List<String> parse(File ddlFile) {
        List<String> list;
        FileInputStream is = new FileInputStream(ddlFile);
        try {
            list = this.parse(is);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        ((InputStream)is).close();
        return list;
    }

    public List<String> parse(InputStream ddlStream) throws IOException {
        String line;
        LinkedList<String> rval = new LinkedList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(ddlStream, StandardCharsets.UTF_8));
        StringBuilder builder = new StringBuilder();
        boolean isInMultiLineStatement = false;
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("--") || line.trim().isEmpty() && !isInMultiLineStatement) continue;
            if (line.trim().isEmpty() && isInMultiLineStatement) {
                isInMultiLineStatement = false;
            }
            if (line.endsWith("'") || line.endsWith("(")) {
                isInMultiLineStatement = true;
            }
            if (line.startsWith("'") || line.startsWith(")")) {
                isInMultiLineStatement = false;
            }
            if (line.startsWith("CREATE FUNCTION")) {
                isInMultiLineStatement = true;
            }
            builder.append(line);
            builder.append("\n");
            if (isInMultiLineStatement) continue;
            String sqlStatement = builder.toString().trim();
            if (sqlStatement.endsWith(";")) {
                sqlStatement = sqlStatement.substring(0, sqlStatement.length() - 1);
            }
            rval.add(sqlStatement);
            builder = new StringBuilder();
        }
        return rval;
    }
}

