/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.sql;

import io.apicurio.registry.storage.impl.sql.CommonSqlStatements;

public class SQLServerSqlStatements
extends CommonSqlStatements {
    @Override
    public String dbType() {
        return "mssql";
    }

    @Override
    public boolean isPrimaryKeyViolation(Exception error) {
        return error.getMessage().contains("Violation of PRIMARY KEY constraint");
    }

    @Override
    public boolean isForeignKeyViolation(Exception error) {
        return error.getMessage().contains("conflicted with the FOREIGN KEY constraint");
    }

    @Override
    public String isDatabaseInitialized() {
        return "SELECT count(*) AS count FROM information_schema.tables WHERE table_name = 'artifacts'";
    }

    @Override
    public String upsertContent() {
        return String.join((CharSequence)" ", "MERGE INTO content AS target", "USING (VALUES (?, ?, ?, ?, ?, ?)) AS source (tenantId, contentId, canonicalHash, contentHash, content, artifactreferences)", "ON (target.tenantId = source.tenantId AND target.contentHash = source.contentHash)", "WHEN NOT MATCHED THEN", "INSERT (tenantId, contentId, canonicalHash, contentHash, content, artifactreferences)", "VALUES (source.tenantId, source.contentId, source.canonicalHash, source.contentHash, source.content, source.artifactreferences);");
    }

    @Override
    public String upsertLogConfiguration() {
        return String.join((CharSequence)" ", "MERGE INTO logconfiguration AS target", "USING (VALUES  (?, ?)) AS source (logger, loglevel)", "ON target.logger = source.logger", "WHEN MATCHED THEN", "UPDATE SET loglevel = ?", "WHEN NOT MATCHED THEN", "INSERT (logger, loglevel)", "VALUES (source.logger, source.loglevel);");
    }

    @Override
    public String getNextSequenceValue() {
        return String.join((CharSequence)" ", "MERGE INTO sequences AS target", "USING (VALUES  (?, ?)) AS source (tenantId, name)", "ON (target.tenantId = source.tenantId AND target.name = source.name)", "WHEN MATCHED THEN", "UPDATE SET value = target.value + 1", "WHEN NOT MATCHED THEN", "INSERT (tenantId, name, value)", "VALUES (source.tenantId, source.name, 1)", "OUTPUT INSERTED.value;");
    }

    @Override
    public String resetSequenceValue() {
        return String.join((CharSequence)" ", "MERGE INTO sequences AS target", "USING (VALUES (?, ?, ?)) AS source (tenantId, name, value)", "ON (target.tenantId = source.tenantId AND target.name = source.name)", "WHEN MATCHED THEN", "UPDATE SET value = ?", "WHEN NOT MATCHED THEN", "INSERT (tenantId, name, value)", "VALUES (source.tenantId, source.name, source.value)", "OUTPUT INSERTED.value;");
    }

    @Override
    public String upsertReference() {
        return String.join((CharSequence)" ", "MERGE INTO artifactreferences AS target", "USING (VALUES (?, ?, ?, ?, ?, ?)) AS source (tenantId, contentId, groupId, artifactId, version, name)", "ON (target.tenantId = source.tenantId AND target.contentId = source.contentId AND target.name = source.name)", "WHEN NOT MATCHED THEN", "INSERT (tenantId, contentId, groupId, artifactId, version, name)", "VALUES (source.tenantId, source.contentId, source.groupId, source.artifactId, source.version, source.name);");
    }

    @Override
    public String selectArtifactIds() {
        return "SELECT TOP (?) artifactId FROM artifacts WHERE tenantId = ?";
    }

    @Override
    public String selectAllArtifactVersions() {
        return "SELECT v.*, a.type FROM versions v JOIN artifacts a ON a.tenantId = v.tenantId AND a.groupId = v.groupId AND a.artifactId = v.artifactId WHERE a.tenantId = ? AND a.groupId = ? AND a.artifactId = ? ORDER BY v.globalId ASC OFFSET ? ROWS FETCH NEXT ? ROWS ONLY";
    }

    @Override
    public String selectGroups() {
        return "SELECT TOP (?) * FROM groups WHERE tenantId = ?ORDER BY groupId ASC";
    }
}

