/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.sql;

import io.apicurio.common.apps.config.Info;
import io.apicurio.registry.storage.impl.sql.H2SqlStatements;
import io.apicurio.registry.storage.impl.sql.MySQLSqlStatements;
import io.apicurio.registry.storage.impl.sql.PostgreSQLSqlStatements;
import io.apicurio.registry.storage.impl.sql.SQLServerSqlStatements;
import io.apicurio.registry.storage.impl.sql.SqlStatements;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;

@ApplicationScoped
public class SqlStatementsProducer {
    @Inject
    Logger log;
    @ConfigProperty(name="quarkus.datasource.db-kind", defaultValue="postgresql")
    @Info(category="store", description="Datasource Db kind", availableSince="2.0.0.Final")
    String databaseType;

    @Produces
    @ApplicationScoped
    public SqlStatements createSqlStatements() {
        this.log.debug("Creating an instance of ISqlStatements for DB: " + this.databaseType);
        if ("h2".equals(this.databaseType)) {
            return new H2SqlStatements();
        }
        if ("mssql".equals(this.databaseType)) {
            return new SQLServerSqlStatements();
        }
        if ("postgresql".equals(this.databaseType)) {
            return new PostgreSQLSqlStatements();
        }
        if ("mysql".equals(this.databaseType)) {
            return new MySQLSqlStatements();
        }
        throw new RuntimeException("Unsupported database type: " + this.databaseType);
    }
}

