/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.sql.upgrader;

import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.canon.ContentCanonicalizer;
import io.apicurio.registry.storage.impl.sql.IDbUpgrader;
import io.apicurio.registry.storage.impl.sql.jdb.Handle;
import io.apicurio.registry.storage.impl.sql.jdb.RowMapper;
import io.apicurio.registry.storage.impl.sql.jdb.Update;
import io.apicurio.registry.storage.impl.sql.mappers.ContentEntityMapper;
import io.apicurio.registry.storage.impl.sql.upgrader.ReferencesContentHashUpgrader;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProviderFactory;
import io.apicurio.registry.types.provider.DefaultArtifactTypeUtilProviderImpl;
import io.apicurio.registry.utils.impexp.ContentEntity;
import io.quarkus.runtime.annotations.RegisterForReflection;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.stream.Stream;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterForReflection
public class ReferencesCanonicalHashUpgrader
implements IDbUpgrader {
    private static final Logger logger = LoggerFactory.getLogger(ReferencesContentHashUpgrader.class);
    private static final ArtifactTypeUtilProviderFactory factory = new DefaultArtifactTypeUtilProviderImpl();

    @Override
    public void upgrade(Handle dbHandle) throws Exception {
        Stream<TypeContentEntity> stream;
        String sql = "SELECT c.contentId, c.content, c.canonicalHash, c.contentHash, c.artifactreferences, a.type FROM versions v JOIN content c on c.contentId = v.contentId JOIN artifacts a ON v.tenantId = a.tenantId AND v.groupId = a.groupId AND v.artifactId = a.artifactId ";
        try (Stream<TypeContentEntity> stream2 = stream = dbHandle.createQuery(sql).setFetchSize(50).map(new TenantContentEntityRowMapper()).stream();){
            stream.forEach(entity -> this.updateHash((TypeContentEntity)entity, dbHandle));
        }
    }

    private void updateHash(TypeContentEntity typeContentEntity, Handle dbHandle) {
        try {
            if (typeContentEntity.contentEntity.serializedReferences != null) {
                byte[] referencesBytes = typeContentEntity.contentEntity.serializedReferences.getBytes(StandardCharsets.UTF_8);
                String canonicalContentHash = DigestUtils.sha256Hex((byte[])this.concatContentAndReferences(this.canonicalizeContent(typeContentEntity.contentEntity, typeContentEntity.type).bytes(), referencesBytes));
                String update = "UPDATE content SET canonicalHash = ? WHERE contentId = ? AND contentHash = ?";
                int rowCount = ((Update)((Update)((Update)dbHandle.createUpdate(update).bind(0, canonicalContentHash)).bind(1, typeContentEntity.contentEntity.contentId)).bind(2, typeContentEntity.contentEntity.contentHash)).execute();
                if (rowCount == 0) {
                    logger.warn("content row not matched for hash upgrade contentId {} contentHash {}", (Object)typeContentEntity.contentEntity.contentId, (Object)typeContentEntity.contentEntity.contentHash);
                }
            }
        }
        catch (Exception e) {
            logger.warn("Error found processing content with id {} and hash {}", new Object[]{typeContentEntity.contentEntity.contentId, typeContentEntity.contentEntity.contentHash, e});
        }
    }

    private byte[] concatContentAndReferences(byte[] contentBytes, byte[] referencesBytes) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(contentBytes.length + referencesBytes.length);
        outputStream.write(contentBytes);
        outputStream.write(referencesBytes);
        return outputStream.toByteArray();
    }

    private ContentHandle canonicalizeContent(ContentEntity contentEntity, String type) {
        ContentHandle contentHandle = ContentHandle.create((byte[])contentEntity.contentBytes);
        ContentCanonicalizer canonicalizer = factory.getArtifactTypeProvider(type).getContentCanonicalizer();
        return canonicalizer.canonicalize(contentHandle, Collections.emptyMap());
    }

    public static class TenantContentEntityRowMapper
    implements RowMapper<TypeContentEntity> {
        @Override
        public TypeContentEntity map(ResultSet rs) throws SQLException {
            TypeContentEntity e = new TypeContentEntity();
            e.type = rs.getString("type");
            e.contentEntity = ContentEntityMapper.instance.map(rs);
            return e;
        }
    }

    public static class TypeContentEntity {
        String type;
        ContentEntity contentEntity;
    }
}

