/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ui.config;

import io.apicurio.common.apps.config.Dynamic;
import io.apicurio.common.apps.config.Info;
import io.apicurio.registry.utils.RegistryProperties;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;

@ApplicationScoped
public class UiConfigProperties {
    @Inject
    Logger log;
    @Inject
    @Dynamic(label="UI read-only mode", description="When selected, the Service Registry web console is set to read-only, preventing create, read, update, or delete operations.")
    @ConfigProperty(name="registry.ui.features.readOnly", defaultValue="false")
    @Info(category="ui", description="UI read-only mode", availableSince="1.2.0.Final")
    Supplier<Boolean> featureReadOnly;
    @Inject
    @ConfigProperty(name="registry.ui.features.settings", defaultValue="false")
    @Info(category="ui", description="UI features settings", availableSince="2.2.2.Final")
    boolean featureSettings;
    @Inject
    @ConfigProperty(name="registry.ui.config.uiContextPath", defaultValue="/ui/")
    @Info(category="ui", description="UI context path", availableSince="2.1.0.Final")
    String uiContextPath;
    @Inject
    @ConfigProperty(name="registry.ui.config.uiCodegenEnabled", defaultValue="true")
    @Info(category="ui", description="UI codegen enabled", availableSince="2.4.2.Final")
    boolean uiCodegenEnabled;
    @Inject
    @ConfigProperty(name="registry.ui.config.apiUrl")
    @Info(category="ui", description="UI APIs URL", availableSince="1.3.0.Final")
    String apiUrl;
    @Inject
    @ConfigProperty(name="quarkus.oidc.tenant-enabled", defaultValue="false")
    @Info(category="ui", description="UI OIDC tenant enabled", availableSince="2.0.0.Final")
    boolean tenantEnabled;
    @Inject
    @ConfigProperty(name="registry.ui.config.auth.type", defaultValue="none")
    @Info(category="ui", description="UI auth type", availableSince="2.2.6.Final")
    String uiAuthType;
    @Inject
    @ConfigProperty(name="registry.ui.config.auth.oidc.url", defaultValue="none")
    @Info(category="ui", description="UI auth OIDC URL", availableSince="2.2.6.Final")
    String oidcUrl;
    @Inject
    @ConfigProperty(name="registry.ui.config.auth.oidc.client-id", defaultValue="none")
    @Info(category="ui", description="UI auth OIDC client ID", availableSince="2.2.6.Final")
    String oidcClientId;
    @Inject
    @ConfigProperty(name="registry.ui.config.auth.oidc.redirect-url", defaultValue="none")
    @Info(category="ui", description="UI auth OIDC redirect URL", availableSince="2.2.6.Final")
    String oidcRedirectUri;
    private final Map<String, Object> keycloakConfig = new HashMap<String, Object>();

    public UiConfigProperties(@RegistryProperties(value={"registry.ui.config.auth.keycloak"}) Properties kcProperties) {
        kcProperties.stringPropertyNames().forEach(key -> this.keycloakConfig.put((String)key, kcProperties.get(key)));
    }

    @PostConstruct
    void onConstruct() {
        this.log.debug("============> kcProperties  " + this.keycloakConfig);
        this.log.debug("============> tenantEnabled  " + this.tenantEnabled);
        this.log.debug("============> featureReadOnly  " + this.featureReadOnly);
        this.log.debug("============> featureSettings  " + this.featureSettings);
        this.log.debug("============> uiContextPath  " + this.uiContextPath);
        this.log.debug("============> codegenEnabled  " + this.uiCodegenEnabled);
        this.log.debug("============> apiUrl  " + this.apiUrl);
    }

    public Map<String, Object> getKeycloakProperties() {
        return this.keycloakConfig;
    }

    public boolean isFeatureReadOnly() {
        return this.featureReadOnly.get();
    }

    public boolean isFeatureSettings() {
        return this.featureSettings;
    }

    public String getUiContextPath() {
        return this.uiContextPath;
    }

    public boolean getUiCodegenEnabled() {
        return this.uiCodegenEnabled;
    }

    public String getUi() {
        return this.uiContextPath;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public boolean isAuthenticationEnabled() {
        return this.tenantEnabled;
    }

    public String getUiAuthType() {
        return this.uiAuthType;
    }

    public String getOidcUrl() {
        return this.oidcUrl;
    }

    public String getOidcClientId() {
        return this.oidcClientId;
    }

    public String getOidcRedirectUrl() {
        return this.oidcRedirectUri;
    }
}

