/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ui.servlets;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Date;

public class ResourceCacheControlFilter
implements Filter {
    public static void disableHttpCaching(HttpServletResponse httpResponse) {
        Date now = new Date();
        httpResponse.setDateHeader("Date", now.getTime());
        httpResponse.setDateHeader("Expires", ResourceCacheControlFilter.expiredSinceYesterday(now));
        httpResponse.setHeader("Pragma", "no-cache");
        httpResponse.setHeader("Cache-control", "no-cache, no-store, must-revalidate");
    }

    private static long expiredSinceYesterday(Date now) {
        return now.getTime() - 86400000L;
    }

    public void init(FilterConfig config) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String requestURI = ((HttpServletRequest)request).getRequestURI();
        Date now = new Date();
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpResponse.setDateHeader("Date", now.getTime());
        boolean disableCaching = false;
        if (requestURI == null) {
            disableCaching = true;
        } else if (requestURI.contains("version.js")) {
            disableCaching = true;
        } else if (requestURI.contains("config.js")) {
            disableCaching = true;
        } else if (requestURI.contains("/apis/")) {
            disableCaching = true;
        }
        if (disableCaching) {
            ResourceCacheControlFilter.disableHttpCaching(httpResponse);
        } else {
            httpResponse.setDateHeader("Expires", this.expiresInOneYear(now));
            httpResponse.setHeader("Cache-control", "public, max-age=31536000");
        }
        chain.doFilter(request, response);
    }

    private long expiresInOneYear(Date now) {
        return now.getTime() + 31536000000L;
    }

    public void destroy() {
    }
}

