/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.client;

import io.apicurio.registry.client.RegistryService;
import io.apicurio.registry.rest.beans.ArtifactMetaData;
import io.apicurio.registry.rest.beans.ArtifactSearchResults;
import io.apicurio.registry.rest.beans.EditableMetaData;
import io.apicurio.registry.rest.beans.IfExistsType;
import io.apicurio.registry.rest.beans.Rule;
import io.apicurio.registry.rest.beans.SearchOver;
import io.apicurio.registry.rest.beans.SortOrder;
import io.apicurio.registry.rest.beans.UpdateState;
import io.apicurio.registry.rest.beans.VersionMetaData;
import io.apicurio.registry.rest.beans.VersionSearchResults;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.IoUtil;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.inject.Vetoed;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;

@Vetoed
@Path(value="__dummy_hack_apicurio")
class CachedRegistryService
implements RegistryService {
    private final RegistryService delegate;
    private final Map<String, Map<String, ArtifactMetaData>> cmds = new ConcurrentHashMap<String, Map<String, ArtifactMetaData>>();
    private final Map<String, Map<Integer, VersionMetaData>> vmds = new ConcurrentHashMap<String, Map<Integer, VersionMetaData>>();
    private final Map<Long, ArtifactMetaData> globalAMD = new ConcurrentHashMap<Long, ArtifactMetaData>();

    public CachedRegistryService() {
        this.delegate = null;
    }

    public CachedRegistryService(RegistryService delegate) {
        this.delegate = delegate;
    }

    private RegistryService getDelegate() {
        if (this.delegate == null) {
            throw new IllegalStateException("Null registry service delegate!");
        }
        return this.delegate;
    }

    @Override
    public void reset() {
        this.cmds.clear();
        this.vmds.clear();
        this.globalAMD.clear();
    }

    public ArtifactMetaData getArtifactMetaData(String artifactId) {
        ArtifactMetaData amd = this.getDelegate().getArtifactMetaData(artifactId);
        this.globalAMD.put(amd.getGlobalId(), amd);
        return amd;
    }

    public ArtifactMetaData getArtifactMetaDataByContent(String artifactId, InputStream data) {
        String content = IoUtil.toString((InputStream)data);
        Map map = this.cmds.computeIfAbsent(artifactId, id -> new ConcurrentHashMap());
        return map.computeIfAbsent(content, c -> {
            InputStream copy = IoUtil.toStream((String)content);
            ArtifactMetaData amd = this.getDelegate().getArtifactMetaDataByContent(artifactId, copy);
            this.globalAMD.put(amd.getGlobalId(), amd);
            return amd;
        });
    }

    public ArtifactMetaData getArtifactMetaDataByGlobalId(long globalId) {
        return this.globalAMD.computeIfAbsent(globalId, arg_0 -> ((RegistryService)this.getDelegate()).getArtifactMetaDataByGlobalId(arg_0));
    }

    public VersionMetaData getArtifactVersionMetaData(Integer version, String artifactId) {
        Map map = this.vmds.computeIfAbsent(artifactId, id -> new ConcurrentHashMap());
        return map.computeIfAbsent(version, v -> this.getDelegate().getArtifactVersionMetaData(version, artifactId));
    }

    public CompletionStage<ArtifactMetaData> createArtifact(ArtifactType xRegistryArtifactType, String xRegistryArtifactId, IfExistsType ifExists, InputStream data) {
        CompletionStage cs = this.getDelegate().createArtifact(xRegistryArtifactType, xRegistryArtifactId, ifExists, data);
        return cs.thenApply(amd -> {
            this.globalAMD.put(amd.getGlobalId(), (ArtifactMetaData)amd);
            return amd;
        });
    }

    public List<String> listArtifacts() {
        return this.getDelegate().listArtifacts();
    }

    public CompletionStage<ArtifactMetaData> updateArtifact(String artifactId, ArtifactType xRegistryArtifactType, InputStream data) {
        CompletionStage cs = this.getDelegate().updateArtifact(artifactId, xRegistryArtifactType, data);
        return cs.thenApply(amd -> {
            this.globalAMD.put(amd.getGlobalId(), (ArtifactMetaData)amd);
            return amd;
        });
    }

    public CompletionStage<VersionMetaData> createArtifactVersion(String artifactId, ArtifactType xRegistryArtifactType, InputStream data) {
        CompletionStage cs = this.getDelegate().createArtifactVersion(artifactId, xRegistryArtifactType, data);
        return cs.thenApply(vmd -> {
            Map map = this.vmds.computeIfAbsent(artifactId, id -> new ConcurrentHashMap());
            map.put(vmd.getVersion(), vmd);
            return vmd;
        });
    }

    public Response getLatestArtifact(String artifactId) {
        ArtifactMetaData amd = this.getArtifactMetaData(artifactId);
        return this.getArtifactVersion(amd.getVersion(), amd.getId());
    }

    public Response getArtifactVersion(Integer version, String artifactId) {
        return this.getDelegate().getArtifactVersion(version, artifactId);
    }

    public Response getArtifactByGlobalId(long globalId) {
        return this.getDelegate().getArtifactByGlobalId(globalId);
    }

    public void testUpdateArtifact(String artifactId, ArtifactType xRegistryArtifactType, InputStream content) {
        this.getDelegate().testUpdateArtifact(artifactId, xRegistryArtifactType, content);
    }

    public List<Long> listArtifactVersions(String artifactId) {
        return this.getDelegate().listArtifactVersions(artifactId);
    }

    public void updateArtifactState(String artifactId, UpdateState data) {
        this.getDelegate().updateArtifactState(artifactId, data);
        this.reset();
    }

    public void updateArtifactVersionState(Integer version, String artifactId, UpdateState data) {
        this.getDelegate().updateArtifactVersionState(version, artifactId, data);
        this.reset();
    }

    public void deleteArtifact(String artifactId) {
        this.getDelegate().deleteArtifact(artifactId);
        this.reset();
    }

    public void updateArtifactMetaData(String artifactId, EditableMetaData data) {
        this.getDelegate().updateArtifactMetaData(artifactId, data);
        this.reset();
    }

    public void deleteArtifactVersionMetaData(Integer version, String artifactId) {
        this.getDelegate().deleteArtifactVersionMetaData(version, artifactId);
        this.reset();
    }

    public void updateArtifactVersionMetaData(Integer version, String artifactId, EditableMetaData data) {
        this.getDelegate().updateArtifactVersionMetaData(version, artifactId, data);
        this.reset();
    }

    public Rule getArtifactRuleConfig(RuleType rule, String artifactId) {
        return this.getDelegate().getArtifactRuleConfig(rule, artifactId);
    }

    public Rule updateArtifactRuleConfig(RuleType rule, String artifactId, Rule data) {
        return this.getDelegate().updateArtifactRuleConfig(rule, artifactId, data);
    }

    public void deleteArtifactRule(RuleType rule, String artifactId) {
        this.getDelegate().deleteArtifactRule(rule, artifactId);
    }

    public List<RuleType> listArtifactRules(String artifactId) {
        return this.getDelegate().listArtifactRules(artifactId);
    }

    public void createArtifactRule(String artifactId, Rule data) {
        this.getDelegate().createArtifactRule(artifactId, data);
    }

    public void deleteArtifactRules(String artifactId) {
        this.getDelegate().deleteArtifactRules(artifactId);
    }

    public Rule getGlobalRuleConfig(RuleType rule) {
        return this.getDelegate().getGlobalRuleConfig(rule);
    }

    public Rule updateGlobalRuleConfig(RuleType rule, Rule data) {
        return this.getDelegate().updateGlobalRuleConfig(rule, data);
    }

    public void deleteGlobalRule(RuleType rule) {
        this.getDelegate().deleteGlobalRule(rule);
    }

    public List<RuleType> listGlobalRules() {
        return this.getDelegate().listGlobalRules();
    }

    public void createGlobalRule(Rule data) {
        this.getDelegate().createGlobalRule(data);
    }

    public void deleteAllGlobalRules() {
        this.getDelegate().deleteAllGlobalRules();
    }

    @Override
    public void close() throws Exception {
        this.getDelegate().close();
    }

    public ArtifactSearchResults searchArtifacts(String search, Integer offset, Integer limit, SearchOver over, SortOrder order) {
        return this.getDelegate().searchArtifacts(search, offset, limit, over, order);
    }

    public VersionSearchResults searchVersions(String artifactId, Integer offset, Integer limit) {
        return this.getDelegate().searchVersions(artifactId, offset, limit);
    }
}

