/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.client;

import io.apicurio.registry.client.ext.RestEasyExceptionUnwrapper;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.eclipse.microprofile.rest.client.RestClientBuilder;

public class GenericClient {
    private static final BiFunction<Method, Throwable, Throwable> UNWRAPPER;

    public static <I> I create(Class<I> serviceInterface, String baseUrl) {
        return new Builder<I>(serviceInterface).setBaseUrl(baseUrl).build();
    }

    private GenericClient() {
    }

    static {
        BiFunction<Method, Throwable, Throwable> unwrapper;
        try {
            unwrapper = new RestEasyExceptionUnwrapper();
            unwrapper.apply(null, new Throwable());
        }
        catch (Throwable ignored) {
            unwrapper = (m, t) -> t;
        }
        UNWRAPPER = unwrapper;
    }

    private static class ServiceProxy
    implements InvocationHandler {
        private final AtomicBoolean closed = new AtomicBoolean();
        private final URI baseUri;
        private final ExecutorService executor;
        private final boolean shutdownExecutor;
        private final Map<Class<?>, Object> targets = new ConcurrentHashMap();
        private final Consumer<Object> resultConsumer;
        private final BiFunction<Method, Object[], Object> customMethods;

        private ServiceProxy(Builder<?> builder) {
            this.baseUri = ((Builder)builder).baseUrl;
            this.shutdownExecutor = ((Builder)builder).executor == null;
            this.executor = this.shutdownExecutor ? Executors.newFixedThreadPool(10) : ((Builder)builder).executor;
            this.resultConsumer = ((Builder)builder).resultConsumer;
            this.customMethods = ((Builder)builder).customMethods;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (Proxy.isProxyClass(obj.getClass())) {
                obj = Proxy.getInvocationHandler(obj);
            }
            return this == obj;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            CompletionStage<Object> result;
            Object customResult;
            String methodName = method.getName();
            int paramCount = method.getParameterCount();
            Class<?> rtype = method.getReturnType();
            if ("close".equals(methodName) && paramCount == 0 && rtype == Void.TYPE) {
                if (this.closed.compareAndSet(false, true)) {
                    Throwable ex = null;
                    for (Object o : this.targets.values()) {
                        if (!(o instanceof AutoCloseable)) continue;
                        try {
                            ((AutoCloseable)o).close();
                        }
                        catch (Throwable e) {
                            if (ex == null) {
                                ex = e;
                                continue;
                            }
                            ex.addSuppressed(e);
                        }
                    }
                    if (this.shutdownExecutor) {
                        try {
                            this.executor.shutdown();
                        }
                        catch (Throwable e) {
                            if (ex == null) {
                                ex = e;
                            }
                            ex.addSuppressed(e);
                        }
                    }
                    if (ex != null) {
                        throw ex;
                    }
                }
                return null;
            }
            if (this.closed.get()) {
                throw new IllegalStateException("Client already closed!");
            }
            if (this.customMethods != null && (customResult = this.customMethods.apply(method, args)) != Void.class) {
                return customResult;
            }
            Class<?> targetClass = method.getDeclaringClass();
            Object target = targetClass.isInterface() ? this.targets.computeIfAbsent(targetClass, tc -> RestClientBuilder.newBuilder().baseUri(this.baseUri).executorService(this.executor).build(tc)) : this;
            try {
                result = method.invoke(target, args);
            }
            catch (InvocationTargetException e) {
                throw (Throwable)UNWRAPPER.apply(method, e.getCause());
            }
            if (result instanceof CompletionStage) {
                CompletionStage cs = result;
                result = cs.whenComplete((r, t) -> {
                    if (t != null) {
                        throw new CompletionException((Throwable)UNWRAPPER.apply(method, t instanceof CompletionException ? t.getCause() : t));
                    }
                    if (this.resultConsumer != null) {
                        this.resultConsumer.accept(r);
                    }
                });
            } else if (this.resultConsumer != null) {
                this.resultConsumer.accept(result);
            }
            return result;
        }
    }

    public static class Builder<I> {
        private final Class<I> serviceInterface;
        private URI baseUrl;
        private ExecutorService executor;
        private BiFunction<Method, Object[], Object> customMethods;
        private Consumer<Object> resultConsumer;

        public Builder(Class<I> serviceInterface) {
            if (!serviceInterface.isInterface()) {
                throw new IllegalArgumentException(serviceInterface + " is not an interface");
            }
            this.serviceInterface = serviceInterface;
        }

        public Builder<I> setBaseUrl(String baseUrl) {
            try {
                this.baseUrl = new URI(Objects.requireNonNull(baseUrl));
                return this;
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public Builder<I> setBaseUrl(URI baseUrl) {
            this.baseUrl = Objects.requireNonNull(baseUrl);
            return this;
        }

        public Builder<I> setExecutor(ExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder<I> setCustomMethods(BiFunction<Method, Object[], Object> customMethods) {
            this.customMethods = customMethods;
            return this;
        }

        public Builder<I> setResultConsumer(Consumer<Object> resultConsumer) {
            this.resultConsumer = resultConsumer;
            return this;
        }

        public I build() {
            return this.serviceInterface.cast(Proxy.newProxyInstance(GenericClient.class.getClassLoader(), new Class[]{this.serviceInterface, AutoCloseable.class}, (InvocationHandler)new ServiceProxy(this)));
        }
    }
}

