/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.client;

import io.apicurio.registry.client.CachedRegistryService;
import io.apicurio.registry.client.GenericClient;
import io.apicurio.registry.client.RegistryService;
import io.apicurio.registry.rest.beans.ArtifactMetaData;
import io.apicurio.registry.rest.beans.VersionMetaData;
import io.apicurio.registry.types.ArtifactState;
import java.lang.reflect.Method;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.ws.rs.core.Response;

public class RegistryClient {
    private static final Logger log = Logger.getLogger(RegistryClient.class.getName());

    private RegistryClient() {
    }

    public static RegistryService create(String baseUrl) {
        return new GenericClient.Builder<RegistryService>(RegistryService.class).setBaseUrl(baseUrl).setCustomMethods(RegistryClient::handleReset).setResultConsumer(RegistryClient::handleResult).build();
    }

    public static RegistryService cached(String baseUrl) {
        return RegistryClient.cached(RegistryClient.create(baseUrl));
    }

    public static RegistryService cached(RegistryService delegate) {
        return new CachedRegistryService(delegate);
    }

    private static Object handleReset(Method method, Object[] args) {
        if ("reset".equals(method.getName()) && (args == null || args.length == 0)) {
            return null;
        }
        return Void.class;
    }

    private static void handleResult(Object result) {
        Response response;
        String isDeprecated;
        if (result instanceof ArtifactMetaData) {
            ArtifactMetaData amd = (ArtifactMetaData)result;
            RegistryClient.checkIfDeprecated(() -> ((ArtifactMetaData)amd).getState(), amd.getId(), amd.getVersion());
        } else if (result instanceof VersionMetaData) {
            VersionMetaData vmd = (VersionMetaData)result;
            RegistryClient.checkIfDeprecated(() -> ((VersionMetaData)vmd).getState(), vmd.getId(), vmd.getVersion());
        } else if (result instanceof Response && (isDeprecated = (response = (Response)result).getHeaderString("X-Registry-Deprecated")) != null) {
            String id = response.getHeaderString("X-Registry-ArtifactId");
            String version = response.getHeaderString("X-Registry-Version");
            RegistryClient.checkIfDeprecated(() -> ArtifactState.DEPRECATED, id, version);
        }
    }

    private static void checkIfDeprecated(Supplier<ArtifactState> stateSupplier, String artifactId, Object version) {
        if (stateSupplier.get() == ArtifactState.DEPRECATED) {
            log.warning(String.format("Artifact %s [%s] is deprecated", artifactId, version));
        }
    }
}

