/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.client.exception;

import io.apicurio.registry.rest.client.exception.ArtifactAlreadyExistsException;
import io.apicurio.registry.rest.client.exception.ArtifactNotFoundException;
import io.apicurio.registry.rest.client.exception.BadRequestException;
import io.apicurio.registry.rest.client.exception.DefaultRuleDeletionException;
import io.apicurio.registry.rest.client.exception.InvalidArtifactStateException;
import io.apicurio.registry.rest.client.exception.InvalidArtifactTypeException;
import io.apicurio.registry.rest.client.exception.RestClientException;
import io.apicurio.registry.rest.client.exception.RuleAlreadyExistsException;
import io.apicurio.registry.rest.client.exception.RuleNotFoundException;
import io.apicurio.registry.rest.client.exception.RuleViolationException;
import io.apicurio.registry.rest.client.exception.UnprocessableEntityException;
import io.apicurio.registry.rest.client.exception.VersionNotFoundException;

public class ExceptionMapper {
    public static RestClientException map(RestClientException ex) throws RestClientException {
        if (ex == null || ex.getError() == null || ex.getError().getName() == null) {
            return ex;
        }
        switch (ex.getError().getName()) {
            case "ArtifactAlreadyExistsException": {
                return new ArtifactAlreadyExistsException(ex.getError());
            }
            case "ArtifactNotFoundException": {
                return new ArtifactNotFoundException(ex.getError());
            }
            case "RuleNotFoundException": {
                return new RuleNotFoundException(ex.getError());
            }
            case "RuleAlreadyExistsException": {
                return new RuleAlreadyExistsException(ex.getError());
            }
            case "VersionNotFoundException": {
                return new VersionNotFoundException(ex.getError());
            }
            case "DefaultRuleDeletionException": {
                return new DefaultRuleDeletionException(ex.getError());
            }
            case "RuleViolationException": {
                return new RuleViolationException(ex.getError());
            }
            case "BadRequestException": {
                return new BadRequestException(ex.getError());
            }
            case "InvalidArtifactStateException": {
                return new InvalidArtifactStateException(ex.getError());
            }
            case "UnprocessableEntityException": {
                return new UnprocessableEntityException(ex.getError());
            }
            case "InvalidArtifactTypeException": {
                return new InvalidArtifactTypeException(ex.getError());
            }
        }
        return ex;
    }
}

