/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.client.impl;

import io.apicurio.registry.auth.Auth;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.rest.client.exception.InvalidArtifactIdException;
import io.apicurio.registry.rest.client.request.Parameters;
import io.apicurio.registry.rest.client.request.RequestHandler;
import io.apicurio.registry.rest.client.request.provider.AdminRequestsProvider;
import io.apicurio.registry.rest.client.request.provider.GroupRequestsProvider;
import io.apicurio.registry.rest.client.request.provider.IdRequestsProvider;
import io.apicurio.registry.rest.client.request.provider.SearchRequestsProvider;
import io.apicurio.registry.rest.v2.beans.ArtifactMetaData;
import io.apicurio.registry.rest.v2.beans.ArtifactSearchResults;
import io.apicurio.registry.rest.v2.beans.EditableMetaData;
import io.apicurio.registry.rest.v2.beans.IfExists;
import io.apicurio.registry.rest.v2.beans.LogConfiguration;
import io.apicurio.registry.rest.v2.beans.NamedLogConfiguration;
import io.apicurio.registry.rest.v2.beans.Rule;
import io.apicurio.registry.rest.v2.beans.SortBy;
import io.apicurio.registry.rest.v2.beans.SortOrder;
import io.apicurio.registry.rest.v2.beans.UpdateState;
import io.apicurio.registry.rest.v2.beans.VersionMetaData;
import io.apicurio.registry.rest.v2.beans.VersionSearchResults;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.ArtifactIdValidator;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RegistryClientImpl
implements RegistryClient {
    private final RequestHandler requestHandler;

    public RegistryClientImpl(String endpoint) {
        this(endpoint, Collections.emptyMap(), null);
    }

    public RegistryClientImpl(String endpoint, Map<String, Object> configs) {
        this(endpoint, configs, null);
    }

    public RegistryClientImpl(String endpoint, Map<String, Object> configs, Auth auth) {
        this.requestHandler = new RequestHandler(endpoint, configs, auth);
    }

    @Override
    public InputStream getLatestArtifact(String groupId, String artifactId) {
        return this.requestHandler.sendRequest(GroupRequestsProvider.getLatestArtifact(this.normalizeGid(groupId), artifactId));
    }

    @Override
    public ArtifactMetaData updateArtifact(String groupId, String artifactId, InputStream data) {
        return this.requestHandler.sendRequest(GroupRequestsProvider.updateArtifact(this.normalizeGid(groupId), artifactId, data));
    }

    @Override
    public void deleteArtifact(String groupId, String artifactId) {
        this.requestHandler.sendRequest(GroupRequestsProvider.deleteArtifact(this.normalizeGid(groupId), artifactId));
    }

    @Override
    public ArtifactMetaData getArtifactMetaData(String groupId, String artifactId) {
        return this.requestHandler.sendRequest(GroupRequestsProvider.getArtifactMetaData(this.normalizeGid(groupId), artifactId));
    }

    @Override
    public void updateArtifactMetaData(String groupId, String artifactId, EditableMetaData data) {
        this.requestHandler.sendRequest(GroupRequestsProvider.updateArtifactMetaData(this.normalizeGid(groupId), artifactId, data));
    }

    @Override
    public VersionMetaData getArtifactVersionMetaDataByContent(String groupId, String artifactId, Boolean canonical, InputStream data) {
        Map<String, List<String>> queryParams = canonical != null ? Map.of(Parameters.CANONICAL, Collections.singletonList(String.valueOf(canonical))) : Collections.emptyMap();
        return this.requestHandler.sendRequest(GroupRequestsProvider.getArtifactVersionMetaDataByContent(this.normalizeGid(groupId), artifactId, queryParams, data));
    }

    @Override
    public List<RuleType> listArtifactRules(String groupId, String artifactId) {
        return this.requestHandler.sendRequest(GroupRequestsProvider.listArtifactRules(this.normalizeGid(groupId), artifactId));
    }

    @Override
    public void createArtifactRule(String groupId, String artifactId, Rule data) {
        this.requestHandler.sendRequest(GroupRequestsProvider.createArtifactRule(this.normalizeGid(groupId), artifactId, data));
    }

    @Override
    public void deleteArtifactRules(String groupId, String artifactId) {
        this.requestHandler.sendRequest(GroupRequestsProvider.deleteArtifactRules(this.normalizeGid(groupId), artifactId));
    }

    @Override
    public Rule getArtifactRuleConfig(String groupId, String artifactId, RuleType rule) {
        return this.requestHandler.sendRequest(GroupRequestsProvider.getArtifactRuleConfig(this.normalizeGid(groupId), artifactId, rule));
    }

    @Override
    public Rule updateArtifactRuleConfig(String groupId, String artifactId, RuleType rule, Rule data) {
        return this.requestHandler.sendRequest(GroupRequestsProvider.updateArtifactRuleConfig(this.normalizeGid(groupId), artifactId, rule, data));
    }

    @Override
    public void deleteArtifactRule(String groupId, String artifactId, RuleType rule) {
        this.requestHandler.sendRequest(GroupRequestsProvider.deleteArtifactRule(this.normalizeGid(groupId), artifactId, rule));
    }

    @Override
    public void updateArtifactState(String groupId, String artifactId, UpdateState data) {
        this.requestHandler.sendRequest(GroupRequestsProvider.updateArtifactState(this.normalizeGid(groupId), artifactId, data));
    }

    @Override
    public void testUpdateArtifact(String groupId, String artifactId, InputStream data) {
        this.requestHandler.sendRequest(GroupRequestsProvider.testUpdateArtifact(this.normalizeGid(groupId), artifactId, data));
    }

    @Override
    public InputStream getArtifactVersion(String groupId, String artifactId, String version) {
        return this.requestHandler.sendRequest(GroupRequestsProvider.getArtifactVersion(this.normalizeGid(groupId), artifactId, version));
    }

    @Override
    public VersionMetaData getArtifactVersionMetaData(String groupId, String artifactId, String version) {
        return this.requestHandler.sendRequest(GroupRequestsProvider.getArtifactVersionMetaData(this.normalizeGid(groupId), artifactId, version));
    }

    @Override
    public void updateArtifactVersionMetaData(String groupId, String artifactId, String version, EditableMetaData data) {
        this.requestHandler.sendRequest(GroupRequestsProvider.updateArtifactVersionMetaData(this.normalizeGid(groupId), artifactId, version, data));
    }

    @Override
    public void deleteArtifactVersionMetaData(String groupId, String artifactId, String version) {
        this.requestHandler.sendRequest(GroupRequestsProvider.deleteArtifactVersionMetaData(this.normalizeGid(groupId), artifactId, version));
    }

    @Override
    public void updateArtifactVersionState(String groupId, String artifactId, String version, UpdateState data) {
        this.requestHandler.sendRequest(GroupRequestsProvider.updateArtifactVersionState(this.normalizeGid(groupId), artifactId, version, data));
    }

    @Override
    public VersionSearchResults listArtifactVersions(String groupId, String artifactId, Integer offset, Integer limit) {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        this.checkCommonQueryParams(null, null, limit, offset, queryParams);
        return this.requestHandler.sendRequest(GroupRequestsProvider.listArtifactVersions(this.normalizeGid(groupId), artifactId, queryParams));
    }

    @Override
    public VersionMetaData createArtifactVersion(String groupId, String artifactId, String version, InputStream data) {
        Map<String, String> headers = version != null ? Map.of("X-Registry-Version", version) : Collections.emptyMap();
        return this.requestHandler.sendRequest(GroupRequestsProvider.createArtifactVersion(this.normalizeGid(groupId), artifactId, data, headers));
    }

    @Override
    public ArtifactSearchResults listArtifactsInGroup(String groupId, SortBy orderBy, SortOrder order, Integer offset, Integer limit) {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        this.checkCommonQueryParams(orderBy, order, limit, offset, queryParams);
        return this.requestHandler.sendRequest(GroupRequestsProvider.listArtifactsInGroup(this.normalizeGid(groupId), queryParams));
    }

    @Override
    public ArtifactMetaData createArtifact(String groupId, String artifactId, String version, ArtifactType artifactType, IfExists ifExists, Boolean canonical, InputStream data) {
        if (artifactId != null && !ArtifactIdValidator.isArtifactIdAllowed((String)artifactId)) {
            throw new InvalidArtifactIdException();
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        if (artifactId != null) {
            headers.put("X-Registry-ArtifactId", artifactId);
        }
        if (artifactType != null) {
            headers.put("X-Registry-ArtifactType", artifactType.name());
        }
        if (version != null) {
            headers.put("X-Registry-Version", version);
        }
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        if (canonical != null) {
            queryParams.put(Parameters.CANONICAL, Collections.singletonList(String.valueOf(canonical)));
        }
        if (ifExists != null) {
            queryParams.put(Parameters.IF_EXISTS, Collections.singletonList(ifExists.value()));
        }
        return this.requestHandler.sendRequest(GroupRequestsProvider.createArtifact(this.normalizeGid(groupId), headers, data, queryParams));
    }

    @Override
    public void deleteArtifactsInGroup(String groupId) {
        this.requestHandler.sendRequest(GroupRequestsProvider.deleteArtifactsInGroup(this.normalizeGid(groupId)));
    }

    @Override
    public InputStream getContentById(long contentId) {
        return this.requestHandler.sendRequest(IdRequestsProvider.getContentById(contentId));
    }

    @Override
    public InputStream getContentByGlobalId(long globalId) {
        return this.requestHandler.sendRequest(IdRequestsProvider.getContentByGlobalId(globalId));
    }

    @Override
    public InputStream getContentByHash(String contentHash, Boolean canonical) {
        Map<String, List<String>> queryParams = canonical != null ? Map.of(Parameters.CANONICAL, Collections.singletonList(String.valueOf(canonical))) : Collections.emptyMap();
        return this.requestHandler.sendRequest(IdRequestsProvider.getContentByHash(contentHash, canonical, queryParams));
    }

    @Override
    public ArtifactSearchResults searchArtifacts(String group, String name, String description, List<String> labels, List<String> properties, SortBy orderBy, SortOrder order, Integer offset, Integer limit) {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        if (name != null) {
            queryParams.put(Parameters.NAME, Collections.singletonList(name));
        }
        if (description != null) {
            queryParams.put(Parameters.DESCRIPTION, Collections.singletonList(description));
        }
        if (group != null) {
            queryParams.put(Parameters.GROUP, Collections.singletonList(group));
        }
        this.checkCommonQueryParams(orderBy, order, limit, offset, queryParams);
        if (labels != null && !labels.isEmpty()) {
            queryParams.put(Parameters.LABELS, labels);
        }
        if (properties != null && !properties.isEmpty()) {
            queryParams.put(Parameters.PROPERTIES, properties);
        }
        return this.requestHandler.sendRequest(SearchRequestsProvider.searchArtifacts(queryParams));
    }

    @Override
    public ArtifactSearchResults searchArtifactsByContent(InputStream data, SortBy orderBy, SortOrder order, Integer offset, Integer limit) {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        this.checkCommonQueryParams(orderBy, order, limit, offset, queryParams);
        return this.requestHandler.sendRequest(SearchRequestsProvider.searchArtifactsByContent(data, queryParams));
    }

    @Override
    public List<RuleType> listGlobalRules() {
        return this.requestHandler.sendRequest(AdminRequestsProvider.listGlobalRules());
    }

    @Override
    public void createGlobalRule(Rule data) {
        this.requestHandler.sendRequest(AdminRequestsProvider.createGlobalRule(data));
    }

    @Override
    public void deleteAllGlobalRules() {
        this.requestHandler.sendRequest(AdminRequestsProvider.deleteAllGlobalRules());
    }

    @Override
    public Rule getGlobalRuleConfig(RuleType rule) {
        return this.requestHandler.sendRequest(AdminRequestsProvider.getGlobalRule(rule));
    }

    @Override
    public Rule updateGlobalRuleConfig(RuleType rule, Rule data) {
        return this.requestHandler.sendRequest(AdminRequestsProvider.updateGlobalRuleConfig(rule, data));
    }

    @Override
    public void deleteGlobalRule(RuleType rule) {
        this.requestHandler.sendRequest(AdminRequestsProvider.deleteGlobalRule(rule));
    }

    @Override
    public List<NamedLogConfiguration> listLogConfigurations() {
        return this.requestHandler.sendRequest(AdminRequestsProvider.listLogConfigurations());
    }

    @Override
    public NamedLogConfiguration getLogConfiguration(String logger) {
        return this.requestHandler.sendRequest(AdminRequestsProvider.getLogConfiguration(logger));
    }

    @Override
    public NamedLogConfiguration setLogConfiguration(String logger, LogConfiguration data) {
        return this.requestHandler.sendRequest(AdminRequestsProvider.setLogConfiguration(logger, data));
    }

    @Override
    public NamedLogConfiguration removeLogConfiguration(String logger) {
        return this.requestHandler.sendRequest(AdminRequestsProvider.removeLogConfiguration(logger));
    }

    @Override
    public InputStream exportData() {
        return this.requestHandler.sendRequest(AdminRequestsProvider.exportData());
    }

    @Override
    public void importData(InputStream data) {
        this.requestHandler.sendRequest(AdminRequestsProvider.importData(data));
    }

    @Override
    public void setNextRequestHeaders(Map<String, String> requestHeaders) {
        this.requestHandler.setNextRequestHeaders(requestHeaders);
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.requestHandler.getHeaders();
    }

    private void checkCommonQueryParams(SortBy orderBy, SortOrder order, Integer limit, Integer offset, Map<String, List<String>> queryParams) {
        if (offset != null) {
            queryParams.put(Parameters.OFFSET, Collections.singletonList(String.valueOf(offset)));
        }
        if (limit != null) {
            queryParams.put(Parameters.LIMIT, Collections.singletonList(String.valueOf(limit)));
        }
        if (order != null) {
            queryParams.put(Parameters.SORT_ORDER, Collections.singletonList(order.value()));
        }
        if (orderBy != null) {
            queryParams.put(Parameters.ORDER_BY, Collections.singletonList(orderBy.value()));
        }
    }

    private String normalizeGid(String groupId) {
        return groupId == null ? "default" : groupId;
    }
}

